/*
 * Decompiled with CFR 0.152.
 */
package com.core.glcore.cv;

import com.momocv.MMFrame;
import com.momocv.beauty.BeautyProcessor;
import com.momocv.beauty.BeautyWarpInfo;
import com.momocv.beauty.BeautyWarpParams;
import com.momocv.beauty.BodyWarpInfo;
import com.momocv.beauty.BodyWarpParams;
import com.momocv.videoprocessor.VideoInfo;
import com.momocv.videoprocessor.VideoParams;
import com.momocv.videoprocessor.VideoProcessor;
import java.util.ArrayList;
import java.util.List;

public final class FaceDetector {
    private VideoProcessor mVideoProcessor;
    private boolean isLoadModel = false;
    private List<String> mFaceModelPath = new ArrayList<String>(2);
    private BeautyProcessor mBeautyProcessor;

    private FaceDetector() {
    }

    public FaceDetector setFaceModelPath(List<String> list) {
        if (list.size() < 2) {
            return this;
        }
        this.mFaceModelPath.clear();
        this.mFaceModelPath.addAll(list);
        this.isLoadModel = false;
        return this;
    }

    public void create() {
    }

    public void processFrame(MMFrame mMFrame, VideoParams videoParams, VideoInfo videoInfo) {
        boolean bl;
        if (this.mVideoProcessor == null) {
            this.mVideoProcessor = new VideoProcessor();
        }
        if (!this.isLoadModel && this.mFaceModelPath.size() >= 2 && !(bl = this.mVideoProcessor.LoadModel(this.mFaceModelPath.get(0), this.mFaceModelPath.get(1)))) {
            this.release();
        }
        if (this.mVideoProcessor != null) {
            this.mVideoProcessor.ProcessFrame(mMFrame, videoParams, videoInfo);
        }
    }

    public boolean getWarpKeyPoints(BeautyWarpParams beautyWarpParams, BeautyWarpInfo beautyWarpInfo) {
        if (this.mBeautyProcessor == null) {
            this.mBeautyProcessor = new BeautyProcessor();
        }
        return this.mBeautyProcessor.GetWarpKeyPoints(beautyWarpParams, beautyWarpInfo);
    }

    public boolean getWarpBodyPoints(BodyWarpParams bodyWarpParams, BodyWarpInfo bodyWarpInfo) {
        if (this.mBeautyProcessor == null) {
            this.mBeautyProcessor = new BeautyProcessor();
        }
        return this.mBeautyProcessor.GetWarpedBodyPoints(bodyWarpParams, bodyWarpInfo);
    }

    public void releaseBeautyProcessor() {
        if (this.mBeautyProcessor != null) {
            this.mBeautyProcessor.Release();
            this.mBeautyProcessor = null;
        }
    }

    public void release() {
        if (this.mVideoProcessor != null) {
            this.mVideoProcessor.Release();
        }
    }

    public static FaceDetector getInstance() {
        return SingletonHolder.sFaceDetector;
    }

    private static class SingletonHolder {
        private static final FaceDetector sFaceDetector = new FaceDetector();

        private SingletonHolder() {
        }
    }
}

