/*
 * Decompiled with CFR 0.152.
 */
package com.core.glcore.config;

import android.media.MediaCodec;
import java.nio.ByteBuffer;

public class PacketData {
    public static final int MEDIA_AUDIO_DATA = 0;
    public static final int MEDIA_VIDEO_DATA = 1;
    private ByteBuffer mPacketByteBuffer = null;
    private MediaCodec.BufferInfo mPacketBufInfo = null;
    private int mMeidaType = -1;

    public PacketData(int n) {
        this.mPacketByteBuffer = ByteBuffer.allocate(n);
        this.mPacketBufInfo = new MediaCodec.BufferInfo();
    }

    public PacketData(ByteBuffer byteBuffer) {
        this.mPacketByteBuffer = byteBuffer;
        this.mPacketBufInfo = new MediaCodec.BufferInfo();
    }

    public PacketData(ByteBuffer byteBuffer, MediaCodec.BufferInfo bufferInfo) {
        this.mPacketByteBuffer = ByteBuffer.allocate(bufferInfo.size);
        byteBuffer.position(0);
        byteBuffer.get(this.mPacketByteBuffer.array(), 0, bufferInfo.size);
        this.mPacketByteBuffer.rewind();
        this.mPacketBufInfo = new MediaCodec.BufferInfo();
        this.mPacketBufInfo.size = bufferInfo.size;
        this.mPacketBufInfo.offset = bufferInfo.offset;
        this.mPacketBufInfo.flags = bufferInfo.flags;
        this.mPacketBufInfo.presentationTimeUs = bufferInfo.presentationTimeUs;
    }

    public void setBuffInfo(int n, int n2, int n3, long l, int n4) {
        this.mPacketBufInfo.size = n;
        this.mPacketBufInfo.offset = n2;
        this.mPacketBufInfo.flags = n3;
        this.mPacketBufInfo.presentationTimeUs = l;
        this.mMeidaType = n4;
    }

    public int getMediaType() {
        return this.mMeidaType;
    }

    public ByteBuffer getFrameBuffer() {
        return this.mPacketByteBuffer;
    }

    public void setFrameBuffer(ByteBuffer byteBuffer) {
        this.mPacketByteBuffer = byteBuffer;
    }

    public MediaCodec.BufferInfo getFrameBufferInfo() {
        return this.mPacketBufInfo;
    }
}

