/*
 * Decompiled with CFR 0.152.
 */
package com.core.glcore.config;

import com.core.glcore.config.Size;

public class MRConfig {
    private int filterMode;
    private Size targetVideoSize;
    private Size visualSize;
    private Size encodeSize;
    private int videoBufferQueueNum;
    private int videoBitRate;
    private int videoRotation;
    private int renderingMode;
    private int defaultCamera;
    private int frontCameraDirectionMode;
    private int backCameraDirectionMode;
    private int videoFPS;
    private boolean printDetailMsg;
    private int previewBufferCount;
    private int threadPauseForData;
    private int encoderGopMode;
    private boolean igonoreEncoderAlignment = true;
    private int scaleMode;
    private float scaleRatio;
    private boolean useDefaultEncodeSize;
    private int audioChannels;
    private int audioBufferSize;
    private int audioSampleRate;
    private int crfLevel;

    private MRConfig() {
    }

    public static MRConfig obtain() {
        MRConfig mRConfig = new MRConfig();
        mRConfig.setFilterMode(2);
        mRConfig.setRenderingMode(1);
        mRConfig.setTargetVideoSize(new Size(640, 480));
        mRConfig.setVisualSize(new Size(640, 480));
        mRConfig.setEncodeSize(new Size(352, 640));
        mRConfig.setVideoFPS(20);
        mRConfig.setVideoRotation(0);
        mRConfig.setVideoBufferQueueNum(5);
        mRConfig.setVideoEncodeBitRate(2000000);
        mRConfig.setPrintDetailMsg(false);
        mRConfig.setDefaultCamera(0);
        mRConfig.setBackCameraDirectionMode(16);
        mRConfig.setFrontCameraDirectionMode(16);
        mRConfig.setThreadPauseForData(20);
        mRConfig.setPreviewBufferCount(5);
        mRConfig.setEncoderGopMode(2);
        mRConfig.setScaleMode(0);
        mRConfig.setScaleRatio(1.7777778f);
        mRConfig.setUseDefaultEncodeSize(false);
        mRConfig.setAudioChannels(2);
        mRConfig.setAudioSampleRate(44100);
        mRConfig.setCrfLevel(23);
        mRConfig.setAudioBufferSize(1024);
        return mRConfig;
    }

    public int getVideoFPS() {
        return this.videoFPS;
    }

    public void setVideoFPS(int n) {
        this.videoFPS = n;
    }

    public void igonoreEncoderAlignment(boolean bl) {
        this.igonoreEncoderAlignment = bl;
    }

    public int getVideoBufferQueueNum() {
        return this.videoBufferQueueNum;
    }

    public void setVideoBufferQueueNum(int n) {
        this.videoBufferQueueNum = n;
    }

    public int getVideoBitRate() {
        return this.videoBitRate;
    }

    public void setVideoEncodeBitRate(int n) {
        this.videoBitRate = n;
    }

    public Size getTargetVideoSize() {
        return this.targetVideoSize;
    }

    public void setTargetVideoSize(Size size) {
        this.targetVideoSize = size;
    }

    public int getFilterMode() {
        return this.filterMode;
    }

    public void setFilterMode(int n) {
        this.filterMode = n;
    }

    public int getDefaultCamera() {
        return this.defaultCamera;
    }

    public void setDefaultCamera(int n) {
        this.defaultCamera = n;
    }

    public int getBackCameraDirectionMode() {
        return this.backCameraDirectionMode;
    }

    public void setBackCameraDirectionMode(int n) {
        this.backCameraDirectionMode = n;
    }

    public int getFrontCameraDirectionMode() {
        return this.frontCameraDirectionMode;
    }

    public void setEncoderGopMode(int n) {
        this.encoderGopMode = n;
    }

    public int getEncoderGopMode() {
        return this.encoderGopMode;
    }

    public void setScaleMode(int n) {
        this.scaleMode = n;
    }

    public int getScaleMode() {
        return this.scaleMode;
    }

    public void setScaleRatio(float f) {
        this.scaleRatio = f;
    }

    public float getScaleRatio() {
        return this.scaleRatio;
    }

    public boolean getUseDefaultEncodeSize() {
        return this.useDefaultEncodeSize;
    }

    public void setUseDefaultEncodeSize(boolean bl) {
        this.useDefaultEncodeSize = bl;
    }

    public void setFrontCameraDirectionMode(int n) {
        this.frontCameraDirectionMode = n;
    }

    public int getRenderingMode() {
        return this.renderingMode;
    }

    public void setRenderingMode(int n) {
        this.renderingMode = n;
    }

    public boolean isPrintDetailMsg() {
        return this.printDetailMsg;
    }

    public void setPrintDetailMsg(boolean bl) {
        this.printDetailMsg = bl;
    }

    public Size getVisualSize() {
        return this.visualSize;
    }

    public void setVisualSize(Size size) {
        this.visualSize = size;
    }

    public Size getEncodeSize() {
        return this.encodeSize;
    }

    public void setEncodeSize(Size size) {
        this.encodeSize = this.igonoreEncoderAlignment ? new Size(size.getWidth() >> 4 << 4, size.getHeight() >> 4 << 4) : new Size(size.getWidth(), size.getHeight());
    }

    public int getPreviewBufferCount() {
        return this.previewBufferCount;
    }

    public void setPreviewBufferCount(int n) {
        this.previewBufferCount = n;
    }

    public int getThreadPauseForData() {
        return this.threadPauseForData;
    }

    public void setThreadPauseForData(int n) {
        this.threadPauseForData = n;
    }

    public int getAudioBufferSize() {
        return this.audioBufferSize;
    }

    public void setAudioBufferSize(int n) {
        this.audioBufferSize = n;
    }

    public void setVideoRotation(int n) {
        this.videoRotation = n;
    }

    public int getVideoRotation() {
        return this.videoRotation;
    }

    public int getAudioChannels() {
        return this.audioChannels;
    }

    public void setAudioChannels(int n) {
        this.audioChannels = n;
    }

    public int getAudioSampleRate() {
        return this.audioSampleRate;
    }

    public void setAudioSampleRate(int n) {
        this.audioSampleRate = n;
    }

    public int getCrfLevel() {
        return this.crfLevel;
    }

    public void setCrfLevel(int n) {
        this.crfLevel = n;
    }

    public static class VideoResolution {
        public static final int RESOLUTION_1920 = 3;
        public static final int RESOLUTION_1280 = 0;
        public static final int RESOLUTION_960 = 1;
        public static final int RESOLUTION_640 = 2;
    }

    public static class EncoderGopMode {
        public static final int NORMAL = 0;
        public static final int IFRAMEONLY = 1;
        public static final int USERENDERINGFPS = 2;
    }

    public static class DirectionMode {
        public static final int FLAG_DIRECTION_FLIP_HORIZONTAL = 1;
        public static final int FLAG_DIRECTION_FLIP_VERTICAL = 2;
        public static final int FLAG_DIRECTION_ROATATION_0 = 16;
        public static final int FLAG_DIRECTION_ROATATION_90 = 32;
        public static final int FLAG_DIRECTION_ROATATION_180 = 64;
        public static final int FLAG_DIRECTION_ROATATION_270 = 128;
    }

    public static class RenderingMode {
        public static final int NativeWindow = 1;
        public static final int OpenGLES = 2;
    }

    public static class FilterMode {
        public static final int HARD = 1;
        public static final int SOFT = 2;
    }
}

