/*
 * Decompiled with CFR 0.152.
 */
package com.core.glcore.camera;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.MeteringRectangle;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.Size;
import com.core.glcore.camera.CameraErrorMap;
import com.core.glcore.camera.ICamera;
import com.core.glcore.camera.ImageReaderUtils;
import com.core.glcore.config.MRConfig;
import com.core.glcore.config.MRCoreParameters;
import com.core.glcore.config.Rotation;
import com.core.glcore.util.Camera2Helpler;
import com.core.glcore.util.MathUtil;
import com.mm.mdlog.MDLog;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class MCamera2
implements ICamera {
    private MRCoreParameters mrCoreParameters;
    private ICamera.ICameraDataCallback dataCallback;
    private Handler childHandler;
    private Handler mainHandler;
    private int mCameraID;
    private int mCurrentCamId = 1;
    private ImageReader mImageReader;
    private CameraDevice mCameraDevice;
    private CameraManager mCameraManager;
    private CameraCaptureSession mCameraCaptureSession;
    public final int FLASH_ON = 1;
    public final int FLASH_OFF = 2;
    private CaptureRequest.Builder mPreviewRequestBuilder;
    private int cameraCount = 0;
    public final int BACK_CAMERA = 0;
    public final int FRONT_CAMERA = 1;
    int cameraRotation = 0;
    private int displayOrientation = 0;
    private com.core.glcore.config.Size cameraPreviewSize;
    private Rect mActiveArraySize = new Rect(0, 0, 1, 1);
    private int screenDegree = 0;
    private HandlerThread cameraHandlerThread = null;
    OnCameraErrorHappend cameraErrorHappend = null;
    private Context managerContex = null;
    private static final int STATE_PREVIEW = 0;
    private static final int STATE_WAITING_LOCK = 1;
    private static final int STATE_WAITING_PRECAPTURE = 2;
    private static final int STATE_WAITING_NON_PRECAPTURE = 3;
    private static final int STATE_PICTURE_TAKEN = 4;
    private int mState = 0;
    CameraDevice.StateCallback stateCallback = new CameraDevice.StateCallback(){

        @TargetApi(value=21)
        @RequiresApi(api=21)
        public void onOpened(@NonNull CameraDevice cameraDevice) {
            MCamera2.this.mCameraOpenCloseLock.release();
            MCamera2.this.mCameraDevice = cameraDevice;
            MCamera2.this.cameraStartPreview();
            MCamera2.this.isFrontCampera = MCamera2.this.checkIsFront();
            MDLog.i((String)"Camera", (String)"Camera2 CameraDevice is opened !!!");
        }

        public void onDisconnected(@NonNull CameraDevice cameraDevice) {
            MCamera2.this.mCameraOpenCloseLock.release();
            cameraDevice.close();
            MCamera2.this.mCameraDevice = null;
            MCamera2.this.disconnectCamera();
            MDLog.i((String)"Camera", (String)"Camera2 CameraDevice is onDisconnected !!!");
        }

        public void onError(@NonNull CameraDevice cameraDevice, int n) {
            MCamera2.this.mCameraOpenCloseLock.release();
            cameraDevice.close();
            MCamera2.this.mCameraDevice = null;
            MCamera2.this.onCameraError(1, CameraErrorMap.ErrorMap.get(1));
            if (MCamera2.this.mOnCameraErrorListener != null) {
                MCamera2.this.mOnCameraErrorListener.onFail(4004, "Camera2 open failed !");
            }
            MDLog.e((String)"Camera", (String)"Camera2 open failed !");
        }
    };
    byte[] byteBuffer = null;
    ImageReader.OnImageAvailableListener onImageAvailableListener = new ImageReader.OnImageAvailableListener(){

        @RequiresApi(api=19)
        public void onImageAvailable(ImageReader imageReader) {
            Image image = imageReader.acquireNextImage();
            MCamera2.this.byteBuffer = ImageReaderUtils.getDataFromImage(image, 2, MCamera2.this.byteBuffer);
            if (MCamera2.this.dataCallback != null && !MCamera2.this.stopDataCallback) {
                MCamera2.this.dataCallback.onData(MCamera2.this.byteBuffer);
            }
            image.close();
        }
    };
    private Boolean flashInfoAvailabel;
    private CaptureRequest mPreviewRequest;
    private ICamera.onCameraErrorListener mOnCameraErrorListener = null;
    private Semaphore mCameraOpenCloseLock = new Semaphore(1);
    private boolean mIsStarting = false;
    private CameraCaptureSession.StateCallback sessionCallback = new CameraCaptureSession.StateCallback(){

        public void onConfigured(@NonNull CameraCaptureSession cameraCaptureSession) {
            if (null == MCamera2.this.mCameraDevice) {
                return;
            }
            MCamera2.this.mCameraCaptureSession = cameraCaptureSession;
            MCamera2.this.startNormalPreview();
        }

        public void onConfigureFailed(@NonNull CameraCaptureSession cameraCaptureSession) {
            cameraCaptureSession.close();
            cameraCaptureSession = null;
            MCamera2.this.mCameraCaptureSession = null;
            if (MCamera2.this.mOnCameraErrorListener != null) {
                MCamera2.this.mOnCameraErrorListener.onFail(4005, "Camera2 config failed !");
            }
            MDLog.e((String)"Camera", (String)"Camera2 config failed !");
        }
    };
    private boolean stopDataCallback = false;
    private boolean isFrontCampera = true;
    private Integer mLastAfState = null;
    private static final long LOCK_FOCUS_DELAY_ON_FOCUSED = 5000L;
    private static final long LOCK_FOCUS_DELAY_ON_UNFOCUSED = 1000L;
    private Runnable mLockAutoFocusRunnable = new Runnable(){

        @Override
        public void run() {
            MCamera2.this.lockAutoFocus();
        }
    };
    private long lastPreCaptureTime = 0L;
    private CameraCaptureSession.CaptureCallback mCaptureCallback = new CameraCaptureSession.CaptureCallback(){

        private void process(CaptureResult captureResult) {
            switch (MCamera2.this.mState) {
                case 0: {
                    MCamera2.this.lastPreCaptureTime = 0L;
                    Integer n = (Integer)captureResult.get(CaptureResult.CONTROL_AF_STATE);
                    if (n != null && !n.equals(MCamera2.this.mLastAfState)) {
                        switch (n) {
                            case 0: {
                                MDLog.i((String)"Camera", (String)"CaptureResult.CONTROL_AF_STATE_INACTIVE");
                                break;
                            }
                            case 3: {
                                MDLog.i((String)"Camera", (String)"CaptureResult.CONTROL_AF_STATE_ACTIVE_SCAN");
                                break;
                            }
                            case 4: {
                                MCamera2.this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)0);
                                MCamera2.this.startNormalPreview();
                                MDLog.i((String)"Camera", (String)"CaptureResult.CONTROL_AF_STATE_FOCUSED_LOCKED");
                                break;
                            }
                            case 5: {
                                MCamera2.this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)0);
                                MCamera2.this.startNormalPreview();
                                MDLog.i((String)"Camera", (String)"CaptureResult.CONTROL_AF_STATE_NOT_FOCUSED_LOCKED");
                                break;
                            }
                            case 6: {
                                MDLog.i((String)"Camera", (String)"CaptureResult.CONTROL_AF_STATE_PASSIVE_UNFOCUSED");
                                break;
                            }
                            case 1: {
                                MDLog.i((String)"Camera", (String)"CaptureResult.CONTROL_AF_STATE_PASSIVE_SCAN");
                                break;
                            }
                            case 2: {
                                MDLog.i((String)"Camera", (String)"CaptureResult.CONTROL_AF_STATE_PASSIVE_FOCUSED");
                            }
                        }
                    }
                    MCamera2.this.mLastAfState = n;
                    break;
                }
                case 1: {
                    MCamera2.this.lastPreCaptureTime = 0L;
                    Integer n = (Integer)captureResult.get(CaptureResult.CONTROL_AF_STATE);
                    if (n == null) {
                        MDLog.i((String)"Camera", (String)"CaptureResult.null");
                        MCamera2.this.captureStillPicture();
                        break;
                    }
                    if (4 != n && 5 != n) break;
                    Integer n2 = (Integer)captureResult.get(CaptureResult.CONTROL_AE_STATE);
                    if (n2 == null || n2 == 2) {
                        MCamera2.this.mState = 4;
                        MDLog.i((String)"Camera", (String)"CaptureResult.still taken");
                        MCamera2.this.captureStillPicture();
                        break;
                    }
                    MDLog.i((String)"Camera", (String)"CaptureResult.null stick taken");
                    MCamera2.this.runPrecaptureSequence();
                    break;
                }
                case 2: {
                    MCamera2.this.lastPreCaptureTime = 0L;
                    Integer n = (Integer)captureResult.get(CaptureResult.CONTROL_AE_STATE);
                    if (n != null && n != 5 && n != 4) break;
                    MCamera2.this.mState = 3;
                    MCamera2.this.lastPreCaptureTime = System.currentTimeMillis();
                    break;
                }
                case 3: {
                    Integer n = (Integer)captureResult.get(CaptureResult.CONTROL_AE_STATE);
                    if (n != null && n == 5 && System.currentTimeMillis() - MCamera2.this.lastPreCaptureTime <= 200L) break;
                    MCamera2.this.mState = 4;
                    MCamera2.this.captureStillPicture();
                    break;
                }
            }
        }

        public void onCaptureProgressed(@NonNull CameraCaptureSession cameraCaptureSession, @NonNull CaptureRequest captureRequest, @NonNull CaptureResult captureResult) {
            this.process(captureResult);
        }

        public void onCaptureCompleted(@NonNull CameraCaptureSession cameraCaptureSession, @NonNull CaptureRequest captureRequest, @NonNull TotalCaptureResult totalCaptureResult) {
            this.process((CaptureResult)totalCaptureResult);
        }
    };
    private CameraCaptureSession.CaptureCallback mAfCaptureCallback = new CameraCaptureSession.CaptureCallback(){

        private void process(CaptureResult captureResult) {
            Integer n = (Integer)captureResult.get(CaptureResult.CONTROL_AF_STATE);
            if (null == n) {
                return;
            }
            if (4 == n || 5 == n) {
                MCamera2.this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)0);
                MDLog.i((String)"Camera", (String)"camera focused ");
                MCamera2.this.startNormalPreview();
            }
        }

        public void onCaptureProgressed(@NonNull CameraCaptureSession cameraCaptureSession, @NonNull CaptureRequest captureRequest, @NonNull CaptureResult captureResult) {
            this.process(captureResult);
        }

        @RequiresApi(api=21)
        public void onCaptureCompleted(@NonNull CameraCaptureSession cameraCaptureSession, @NonNull CaptureRequest captureRequest, @NonNull TotalCaptureResult totalCaptureResult) {
            this.process((CaptureResult)totalCaptureResult);
        }
    };

    public MCamera2(MRCoreParameters mRCoreParameters) {
        this.mrCoreParameters = mRCoreParameters;
        this.cameraCount = Camera2Helpler.getCameraCnt();
    }

    @Override
    public void setCameraDataCallback(ICamera.ICameraDataCallback iCameraDataCallback) {
        this.dataCallback = iCameraDataCallback;
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    @TargetApi(value=21)
    @RequiresApi(api=21)
    public synchronized boolean startPreview(SurfaceTexture surfaceTexture) {
        if (!this.mIsStarting) {
            MDLog.i((String)"Camera", (String)"Camera2 startPreview !!!");
            this.mCameraManager = (CameraManager)this.managerContex.getSystemService("camera");
            try {
                CameraCharacteristics cameraCharacteristics = null;
                cameraCharacteristics = this.mCameraManager.getCameraCharacteristics(this.mCurrentCamId + "");
                this.mActiveArraySize = (Rect)cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
                this.flashInfoAvailabel = (Boolean)cameraCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
                this.isFrontCampera = this.checkIsFront();
                MDLog.i((String)"Camera", (String)("sem is " + this.mCameraOpenCloseLock));
                if (!this.mCameraOpenCloseLock.tryAcquire(2500L, TimeUnit.MILLISECONDS)) {
                    MDLog.e((String)"Camera", (String)"Time out waiting to lock camera opening.");
                    throw new RuntimeException("Time out waiting to lock camera opening.");
                }
                this.mCameraManager.openCamera(this.mCurrentCamId + "", this.stateCallback, this.childHandler);
            }
            catch (CameraAccessException cameraAccessException) {
                MDLog.e((String)"Camera", (String)("Camera2 start preview failed !" + cameraAccessException.toString()));
                this.onCameraError(2, CameraErrorMap.ErrorMap.get(2));
                if (this.mOnCameraErrorListener != null) {
                    this.mOnCameraErrorListener.onFail(4002, "Camera2 start preview failed !");
                }
            }
            catch (InterruptedException interruptedException) {
                MDLog.e((String)"Camera", (String)("Camera2 start preview failed !" + interruptedException.toString()));
            }
            this.mIsStarting = true;
        }
        return true;
    }

    @Override
    @TargetApi(value=21)
    @RequiresApi(api=21)
    public synchronized int stopPreview() {
        if (this.mCameraCaptureSession != null) {
            this.mCameraCaptureSession.close();
            this.mCameraCaptureSession = null;
        }
        if (this.mCameraDevice != null) {
            this.mCameraDevice.close();
            this.mCameraDevice = null;
        }
        this.mIsStarting = false;
        MDLog.i((String)"Camera", (String)"Camera2 stopPreview !");
        return 0;
    }

    @Override
    @TargetApi(value=21)
    @RequiresApi(api=21)
    public synchronized void pauseCamera() {
        this.stopPreview();
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    @TargetApi(value=21)
    @RequiresApi(api=21)
    public synchronized void resumeCamera() {
        this.startPreview(null);
    }

    @Override
    public boolean open() {
        return false;
    }

    private synchronized void startNormalPreview() {
        try {
            if (this.mPreviewRequestBuilder != null && this.mCameraCaptureSession != null) {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
                this.mPreviewRequest = this.mPreviewRequestBuilder.build();
                this.mCameraCaptureSession.setRepeatingRequest(this.mPreviewRequest, this.mCaptureCallback, this.childHandler);
                this.stopDataCallback = false;
            }
        }
        catch (CameraAccessException cameraAccessException) {
            MDLog.e((String)"Camera", (String)("Camera2 startNormalPreview failed !" + cameraAccessException.toString()));
        }
    }

    @RequiresApi(api=21)
    private void cameraStartPreview() {
        block2: {
            try {
                this.mPreviewRequestBuilder = this.mCameraDevice.createCaptureRequest(3);
                this.mPreviewRequestBuilder.addTarget(this.mImageReader.getSurface());
                this.mCameraDevice.createCaptureSession(Arrays.asList(this.mImageReader.getSurface()), this.sessionCallback, this.childHandler);
            }
            catch (CameraAccessException cameraAccessException) {
                MDLog.e((String)"Camera", (String)("Camera2 start preview failed !" + cameraAccessException.getMessage()));
                this.onCameraError(3, CameraErrorMap.ErrorMap.get(3));
                if (this.mOnCameraErrorListener == null) break block2;
                this.mOnCameraErrorListener.onFail(4002, "Camera2 start preview failed !" + cameraAccessException.getMessage());
            }
        }
    }

    private void disconnectCamera() {
    }

    private void onCameraError(int n, String string) {
        if (this.cameraErrorHappend != null) {
            this.cameraErrorHappend.onCameraError(n, string);
        }
    }

    @TargetApi(value=21)
    @RequiresApi(api=21)
    private void getMatchRes(int n, int n2) {
        block8: {
            CameraManager cameraManager = this.mCameraManager;
            try {
                String[] stringArray = cameraManager.getCameraIdList();
                int n3 = stringArray.length;
                int n4 = 0;
                if (n4 >= n3) break block8;
                String string = stringArray[n4];
                CameraCharacteristics cameraCharacteristics = cameraManager.getCameraCharacteristics(string);
                Integer n5 = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
                if (this.mCurrentCamId == 1 && (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) == 0) {
                    StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                    if (streamConfigurationMap == null) break block8;
                    Size[] sizeArray = streamConfigurationMap.getOutputSizes(35);
                    List<Size> list = Arrays.asList(sizeArray);
                    Collections.sort(list, new Comparator<Size>(){

                        @Override
                        public int compare(Size size, Size size2) {
                            if (size.getWidth() * size.getHeight() > size2.getWidth() * size2.getHeight()) {
                                return 1;
                            }
                            return -1;
                        }
                    });
                    int n6 = n * n2;
                    int n7 = 0;
                    int n8 = 0;
                    for (Size size : sizeArray) {
                        int n9 = size.getWidth() * size.getHeight() - n6;
                        if (this.mrCoreParameters.scaleMode != 0 ? this.mrCoreParameters.scaleMode == 1 && (float)size.getHeight() * this.mrCoreParameters.scaleRatio > (float)size.getWidth() : (float)size.getWidth() / this.mrCoreParameters.scaleRatio > (float)size.getHeight()) continue;
                        if (Math.abs(n9) < n6) {
                            if (size.getWidth() > n && size.getHeight() > n2) continue;
                            n6 = Math.abs(n9);
                            n7 = size.getWidth();
                            n8 = size.getHeight();
                            continue;
                        }
                        if (Math.abs(n9) != n6 || n7 >= size.getWidth()) continue;
                        n7 = size.getWidth();
                        n8 = size.getHeight();
                    }
                    if (n7 != 0 && n8 != 0) {
                        this.mrCoreParameters.previewVideoWidth = n7;
                        this.mrCoreParameters.previewVideoHeight = n8;
                    }
                    MDLog.i((String)"Camera", (String)("mrCoreParameters.previewVideoWidth  = " + this.mrCoreParameters.previewVideoWidth + " mrCoreParameters.previewVideoHeigh = " + this.mrCoreParameters.previewVideoHeight));
                }
                return;
            }
            catch (CameraAccessException cameraAccessException) {
                cameraAccessException.printStackTrace();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    @TargetApi(value=21)
    @RequiresApi(api=19)
    public synchronized boolean prepare(int n, MRConfig mRConfig) {
        if (this.cameraCount - 1 >= mRConfig.getDefaultCamera()) {
            this.mCurrentCamId = mRConfig.getDefaultCamera();
        }
        if (this.childHandler == null) {
            this.cameraHandlerThread = new HandlerThread("Camera2");
            this.cameraHandlerThread.start();
            this.childHandler = new Handler(this.cameraHandlerThread.getLooper());
        }
        if (this.mainHandler == null) {
            this.mainHandler = new Handler(Looper.getMainLooper());
        }
        this.screenDegree = n;
        this.adjustCameraOrientation(this.screenDegree);
        this.mrCoreParameters.previewVideoWidth = mRConfig.getTargetVideoSize().getWidth();
        this.mrCoreParameters.previewVideoHeight = mRConfig.getTargetVideoSize().getHeight();
        int n2 = this.mrCoreParameters.previewVideoWidth;
        int n3 = this.mrCoreParameters.previewVideoHeight;
        this.cameraPreviewSize = new com.core.glcore.config.Size(this.mrCoreParameters.previewVideoWidth, this.mrCoreParameters.previewVideoHeight);
        if (this.mImageReader == null) {
            this.mImageReader = ImageReader.newInstance((int)this.mrCoreParameters.previewVideoWidth, (int)this.mrCoreParameters.previewVideoHeight, (int)35, (int)3);
            this.mImageReader.setOnImageAvailableListener(this.onImageAvailableListener, this.childHandler);
        }
        if (mRConfig.getScaleMode() == 1) {
            n2 = (int)((float)n3 * mRConfig.getScaleRatio());
            if (n2 != this.mrCoreParameters.previewVideoWidth) {
                n2 = n2 >> 4 << 4;
            }
        } else if (mRConfig.getScaleMode() == 0 && (n3 = (int)((float)n2 / mRConfig.getScaleRatio())) != this.mrCoreParameters.previewVideoHeight) {
            n3 = n3 >> 4 << 4;
        }
        com.core.glcore.config.Size size = null;
        size = this.cameraRotation == 1 || this.cameraRotation == 3 ? new com.core.glcore.config.Size(n3, n2) : new com.core.glcore.config.Size(n2, n3);
        if (this.mrCoreParameters.useDefaultEncodeSize) {
            if (size != null && size.getWidth() > 0 && size.getHeight() > 0) {
                this.mrCoreParameters.encodeWidth = size.getWidth();
                this.mrCoreParameters.encodeHeight = size.getHeight();
                mRConfig.setEncodeSize(size);
            }
        } else {
            size = mRConfig.getEncodeSize();
            if (size != null && size.getWidth() > 0 && size.getHeight() > 0) {
                this.mrCoreParameters.encodeWidth = size.getWidth();
                this.mrCoreParameters.encodeHeight = size.getHeight();
            }
        }
        MDLog.i((String)"Camera", (String)("Camera2 prepare mrCoreParameters.encodeWidth = " + this.mrCoreParameters.encodeWidth + " mrCoreParameters.encodeHeight = " + this.mrCoreParameters.encodeHeight));
        return true;
    }

    @Override
    public int getDisplayOrientation() {
        return this.displayOrientation;
    }

    @Override
    public int getCameraRotation() {
        return this.cameraRotation * 90;
    }

    @Override
    @RequiresApi(api=21)
    public void adjustCameraOrientation(int n) {
        block9: {
            try {
                CameraCharacteristics cameraCharacteristics = null;
                cameraCharacteristics = this.mCameraManager.getCameraCharacteristics(this.mCurrentCamId + "");
                int n2 = (Integer)cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
                if (this.isFront()) {
                    this.displayOrientation = (n2 + n) % 360;
                    this.displayOrientation = (360 - this.displayOrientation) % 360;
                } else {
                    this.displayOrientation = (n2 - n + 360) % 360;
                }
                Rotation rotation = Rotation.NORMAL;
                switch (this.displayOrientation) {
                    case 90: {
                        rotation = Rotation.ROTATION_90;
                        break;
                    }
                    case 180: {
                        rotation = Rotation.ROTATION_180;
                        break;
                    }
                    case 270: {
                        rotation = Rotation.ROTATION_270;
                    }
                }
                this.cameraRotation = rotation.ordinal();
            }
            catch (CameraAccessException cameraAccessException) {
                MDLog.e((String)"Camera", (String)("Camera2 config Camera Orientation failed !" + cameraAccessException.toString()));
                this.onCameraError(4, CameraErrorMap.ErrorMap.get(4));
                if (this.mOnCameraErrorListener == null) break block9;
                this.mOnCameraErrorListener.onFail(4005, "Camera2 config Camera Orientation failed !");
            }
        }
    }

    private com.core.glcore.config.Size getMaxSize(com.core.glcore.config.Size[] sizeArray) {
        com.core.glcore.config.Size size = null;
        if (sizeArray != null) {
            size = sizeArray[0];
            for (com.core.glcore.config.Size size2 : sizeArray) {
                if (size2.getWidth() * size2.getHeight() <= size.getWidth() * size.getHeight()) continue;
                size = size2;
            }
        }
        return size;
    }

    @RequiresApi(api=21)
    private void restart() {
        this.stopPreview();
        this.startPreview(null);
    }

    @Override
    @TargetApi(value=21)
    @RequiresApi(api=21)
    public synchronized boolean switchCamera(int n, MRConfig mRConfig) {
        block5: {
            try {
                MDLog.i((String)"Camera", (String)"Camera2 switchCamera !!!");
                for (String string : this.mCameraManager.getCameraIdList()) {
                    CameraCharacteristics cameraCharacteristics = this.mCameraManager.getCameraCharacteristics(string);
                    StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                    if (this.mCurrentCamId == 1 && (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) == 0) {
                        this.stopDataCallback = true;
                        this.mCurrentCamId = 0;
                        this.restart();
                    } else {
                        if (this.mCurrentCamId != 0 || (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) != 1) continue;
                        this.stopDataCallback = true;
                        this.mCurrentCamId = 1;
                        this.restart();
                    }
                    break;
                }
            }
            catch (CameraAccessException cameraAccessException) {
                MDLog.e((String)"Camera", (String)("Camera2 switch Camera failed !" + cameraAccessException.toString()));
                this.onCameraError(5, CameraErrorMap.ErrorMap.get(5));
                if (this.mOnCameraErrorListener == null) break block5;
                this.mOnCameraErrorListener.onFail(4008, "Camera2 switch Camera failed !");
            }
        }
        return false;
    }

    @Override
    @TargetApi(value=21)
    @RequiresApi(api=21)
    public synchronized void release() {
        if (this.mImageReader != null) {
            this.mImageReader.close();
            this.mImageReader = null;
        }
        if (this.mCameraCaptureSession != null) {
            this.mCameraCaptureSession.close();
            this.mCameraCaptureSession = null;
        }
        if (this.mCameraDevice != null) {
            this.mCameraDevice.close();
        }
        this.mPreviewRequestBuilder = null;
        this.mCameraManager = null;
        if (this.cameraHandlerThread != null) {
            this.childHandler = null;
            this.mainHandler = null;
            this.cameraHandlerThread.quitSafely();
        }
        MDLog.i((String)"Camera", (String)"Camera2 release !!!");
    }

    @RequiresApi(api=21)
    private boolean checkIsFront() {
        if (this.mCameraManager != null) {
            block5: {
                try {
                    for (String string : this.mCameraManager.getCameraIdList()) {
                        CameraCharacteristics cameraCharacteristics = this.mCameraManager.getCameraCharacteristics(string);
                        StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                        if (this.mCurrentCamId == 1 && (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) == 0) {
                            return true;
                        }
                        if (this.mCurrentCamId != 0 || (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) != 1) continue;
                        return false;
                    }
                }
                catch (CameraAccessException cameraAccessException) {
                    MDLog.e((String)"Camera", (String)("Get Camera2 is front failed !" + cameraAccessException.toString()));
                    this.onCameraError(6, CameraErrorMap.ErrorMap.get(6));
                    if (this.mOnCameraErrorListener == null) break block5;
                    this.mOnCameraErrorListener.onFail(4007, "Get Camera2 is front failed !");
                }
            }
            return false;
        }
        return false;
    }

    @Override
    @RequiresApi(api=21)
    public boolean isFront() {
        return this.isFrontCampera;
    }

    @Override
    @RequiresApi(api=21)
    public boolean isSupportFlashMode() {
        block3: {
            CameraCharacteristics cameraCharacteristics = null;
            try {
                if (this.mCameraManager != null) {
                    cameraCharacteristics = this.mCameraManager.getCameraCharacteristics(String.valueOf(this.mCurrentCamId));
                    Boolean bl = (Boolean)cameraCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
                    return bl;
                }
            }
            catch (CameraAccessException cameraAccessException) {
                MDLog.e((String)"Camera", (String)("Get camera2 is support flash mode error!" + cameraAccessException.getMessage()));
                this.onCameraError(7, CameraErrorMap.ErrorMap.get(7));
                if (this.mOnCameraErrorListener == null) break block3;
                this.mOnCameraErrorListener.onFail(4007, "Get camera2 is support flash mode error!" + cameraAccessException.getMessage());
            }
        }
        return false;
    }

    @Override
    @RequiresApi(api=23)
    public void openTorch() {
        block3: {
            try {
                if (this.mCameraManager != null) {
                    this.mCameraManager.setTorchMode(String.valueOf(this.mCurrentCamId), true);
                }
            }
            catch (CameraAccessException cameraAccessException) {
                MDLog.e((String)"Camera", (String)("Set Camera2 torch mode error!" + cameraAccessException.getMessage()));
                this.onCameraError(8, CameraErrorMap.ErrorMap.get(8));
                if (this.mOnCameraErrorListener == null) break block3;
                this.mOnCameraErrorListener.onFail(4005, "Set Camera2 torch mode error!" + cameraAccessException.getMessage());
            }
        }
    }

    @Override
    @RequiresApi(api=23)
    public void closeTorch() {
        block3: {
            try {
                if (this.mCameraManager != null) {
                    this.mCameraManager.setTorchMode(String.valueOf(this.mCurrentCamId), false);
                }
            }
            catch (CameraAccessException cameraAccessException) {
                MDLog.e((String)"Camera", (String)("Set Camera2 torch mode close error!" + cameraAccessException.getMessage()));
                this.onCameraError(9, CameraErrorMap.ErrorMap.get(9));
                if (this.mOnCameraErrorListener == null) break block3;
                this.mOnCameraErrorListener.onFail(4005, "Set Camera2 torch mode close error!" + cameraAccessException.getMessage());
            }
        }
    }

    @Override
    public boolean isSupportZoom() {
        return false;
    }

    @Override
    public void setZoomLevel(int n) {
    }

    @Override
    public int getCurrentZoomLevel() {
        return 0;
    }

    @Override
    public int getMaxZoomLevel() {
        return 0;
    }

    public void lockAutoFocus() {
        block2: {
            try {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
                CaptureRequest captureRequest = this.mPreviewRequestBuilder.build();
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, null);
                this.mCameraCaptureSession.capture(captureRequest, this.mCaptureCallback, this.childHandler);
            }
            catch (CameraAccessException cameraAccessException) {
                MDLog.e((String)"Camera", (String)("Set Camera2 lock auto focus mode error!" + cameraAccessException.getMessage()));
                if (this.mOnCameraErrorListener == null) break block2;
                this.mOnCameraErrorListener.onFail(4005, "Set Camera2 lock auto focus mode error!" + cameraAccessException.getMessage());
            }
        }
        MDLog.i((String)"Camera", (String)"Camera2 lockAutoFocus !!!");
    }

    private void unlockFocus() {
        block2: {
            try {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
                this.setAutoFlash(this.mPreviewRequestBuilder);
                this.mCameraCaptureSession.capture(this.mPreviewRequestBuilder.build(), this.mCaptureCallback, this.childHandler);
                this.mState = 0;
                this.mCameraCaptureSession.setRepeatingRequest(this.mPreviewRequest, this.mCaptureCallback, this.childHandler);
            }
            catch (CameraAccessException cameraAccessException) {
                MDLog.e((String)"Camera", (String)("Cancel Camera2 lock auto focus mode error!" + cameraAccessException.getMessage()));
                if (this.mOnCameraErrorListener == null) break block2;
                this.mOnCameraErrorListener.onFail(4005, "Cancel Camera2 lock auto focus mode error!" + cameraAccessException.getMessage());
            }
        }
    }

    private void setAutoFlash(CaptureRequest.Builder builder) {
        if (this.flashInfoAvailabel.booleanValue()) {
            // empty if block
        }
    }

    private void captureStillPicture() {
        block3: {
            try {
                if (null == this.mCameraDevice) {
                    return;
                }
                CaptureRequest.Builder builder = this.mCameraDevice.createCaptureRequest(2);
                builder.addTarget(this.mImageReader.getSurface());
                builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
                this.setAutoFlash(builder);
                CameraCaptureSession.CaptureCallback captureCallback = new CameraCaptureSession.CaptureCallback(){

                    public void onCaptureCompleted(@NonNull CameraCaptureSession cameraCaptureSession, @NonNull CaptureRequest captureRequest, @NonNull TotalCaptureResult totalCaptureResult) {
                        MCamera2.this.unlockFocus();
                    }
                };
                this.mCameraCaptureSession.stopRepeating();
                this.mCameraCaptureSession.abortCaptures();
                this.mCameraCaptureSession.capture(builder.build(), captureCallback, null);
            }
            catch (CameraAccessException cameraAccessException) {
                MDLog.e((String)"Camera", (String)("Camera2 take photo error!" + cameraAccessException.getMessage()));
                if (this.mOnCameraErrorListener == null) break block3;
                this.mOnCameraErrorListener.onFail(4009, "Camera2 take photo error!" + cameraAccessException.getMessage());
            }
        }
    }

    private void runPrecaptureSequence() {
        try {
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
            this.mState = 2;
            this.mCameraCaptureSession.capture(this.mPreviewRequestBuilder.build(), this.mCaptureCallback, this.childHandler);
        }
        catch (CameraAccessException cameraAccessException) {
            MDLog.e((String)"Camera", (String)("Camera2 runPrecaptureSequence failed !!!" + cameraAccessException.toString()));
        }
    }

    @RequiresApi(api=21)
    private float getMinimumFocusDistance() {
        Float f = null;
        try {
            CameraCharacteristics cameraCharacteristics = this.mCameraManager.getCameraCharacteristics(this.mCurrentCamId + "");
            f = (Float)cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_MINIMUM_FOCUS_DISTANCE);
        }
        catch (Exception exception) {
            MDLog.e((String)"Camera", (String)("isHardwareLevelSupported Error" + exception.toString()));
        }
        if (f != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    private boolean isAutoFocusSupported() {
        return this.isHardwareLevelSupported(2) || this.getMinimumFocusDistance() > 0.0f;
    }

    @TargetApi(value=21)
    private boolean isHardwareLevelSupported(int n) {
        boolean bl = false;
        try {
            CameraCharacteristics cameraCharacteristics = this.mCameraManager.getCameraCharacteristics(this.mCurrentCamId + "");
            int n2 = (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
            switch (n2) {
                case 3: {
                    MDLog.i((String)"Camera", (String)"Camera support level: INFO_SUPPORTED_HARDWARE_LEVEL_3");
                    break;
                }
                case 1: {
                    MDLog.i((String)"Camera", (String)"Camera support level: INFO_SUPPORTED_HARDWARE_LEVEL_FULL");
                    break;
                }
                case 2: {
                    MDLog.i((String)"Camera", (String)"Camera support level: INFO_SUPPORTED_HARDWARE_LEVEL_LEGACY");
                    break;
                }
                case 0: {
                    MDLog.i((String)"Camera", (String)"Camera support level: INFO_SUPPORTED_HARDWARE_LEVEL_LIMITED");
                    break;
                }
                default: {
                    MDLog.i((String)"Camera", (String)("Unknown INFO_SUPPORTED_HARDWARE_LEVEL: " + n2));
                }
            }
            bl = n2 == 2 ? n == n2 : n <= n2;
        }
        catch (Exception exception) {
            MDLog.e((String)"Camera", (String)("isHardwareLevelSupported Error" + exception.toString()));
        }
        return bl;
    }

    @Override
    @RequiresApi(api=21)
    public void focusOnTouch(double d, double d2, int n, int n2) {
        if (null == this.mCameraDevice || null == this.mCameraCaptureSession || null == this.mPreviewRequestBuilder) {
            return;
        }
        int n3 = this.cameraPreviewSize.getWidth();
        int n4 = this.cameraPreviewSize.getHeight();
        if (90 == this.displayOrientation || 270 == this.displayOrientation) {
            n3 = this.cameraPreviewSize.getHeight();
            n4 = this.cameraPreviewSize.getWidth();
        }
        double d3 = 1.0;
        double d4 = 0.0;
        double d5 = 0.0;
        if (n4 * n > n3 * n2) {
            d3 = (double)n * 1.0 / (double)n3;
            d4 = ((double)n4 - (double)n2 / d3) / 2.0;
        } else {
            d3 = (double)n2 * 1.0 / (double)n4;
            d5 = ((double)n3 - (double)n / d3) / 2.0;
        }
        d = d / d3 + d5;
        d2 = d2 / d3 + d4;
        if (90 == this.displayOrientation) {
            double d6 = d;
            d = d2;
            d2 = (double)this.cameraPreviewSize.getHeight() - d6;
        } else if (270 == this.displayOrientation) {
            double d7 = d;
            d = (double)this.cameraPreviewSize.getWidth() - d2;
            d2 = d7;
        }
        Rect rect = (Rect)this.mPreviewRequestBuilder.get(CaptureRequest.SCALER_CROP_REGION);
        if (null == rect) {
            MDLog.e((String)"Camera", (String)"can't get crop region");
            rect = this.mActiveArraySize;
        }
        int n5 = rect.width();
        int n6 = rect.height();
        if (this.cameraPreviewSize.getHeight() * n5 > this.cameraPreviewSize.getWidth() * n6) {
            d3 = (double)n6 * 1.0 / (double)this.cameraPreviewSize.getHeight();
            d4 = 0.0;
            d5 = ((double)n5 - d3 * (double)this.cameraPreviewSize.getWidth()) / 2.0;
        } else {
            d3 = (double)n5 * 1.0 / (double)this.cameraPreviewSize.getWidth();
            d5 = 0.0;
            d4 = ((double)n6 - d3 * (double)this.cameraPreviewSize.getHeight()) / 2.0;
        }
        d = d * d3 + d5 + (double)rect.left;
        d2 = d2 * d3 + d4 + (double)rect.top;
        double d8 = 0.1;
        Rect rect2 = new Rect();
        rect2.left = MathUtil.clamp((int)(d - d8 / 2.0 * (double)rect.width()), 0, rect.width());
        rect2.right = MathUtil.clamp((int)(d + d8 / 2.0 * (double)rect.width()), 0, rect.width());
        rect2.top = MathUtil.clamp((int)(d2 - d8 / 2.0 * (double)rect.height()), 0, rect.height());
        rect2.bottom = MathUtil.clamp((int)(d2 + d8 / 2.0 * (double)rect.height()), 0, rect.height());
        this.focusOnRect(rect2, null);
    }

    @Override
    @RequiresApi(api=21)
    public void focusOnRect(Rect rect, Camera.AutoFocusCallback autoFocusCallback) {
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)new MeteringRectangle[]{new MeteringRectangle(rect, 1000)});
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_REGIONS, (Object)new MeteringRectangle[]{new MeteringRectangle(rect, 1000)});
        if (this.isAutoFocusSupported()) {
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
        } else {
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
        }
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
        CaptureRequest captureRequest = this.mPreviewRequestBuilder.build();
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_REGIONS, null);
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, null);
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, null);
        try {
            this.mCameraCaptureSession.setRepeatingRequest(captureRequest, this.mCaptureCallback, this.childHandler);
        }
        catch (CameraAccessException cameraAccessException) {
            MDLog.e((String)"Camera", (String)("setRepeatingRequest failed, " + cameraAccessException.getMessage()));
        }
    }

    @Override
    public void setOnCameraSetListener(ICamera.onCameraSetListener onCameraSetListener2) {
    }

    @Override
    public void takePicture(String string) {
        this.lockFocus();
    }

    private void lockFocus() {
        try {
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
            this.mState = 1;
            this.mCameraCaptureSession.capture(this.mPreviewRequestBuilder.build(), this.mCaptureCallback, this.childHandler);
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, null);
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, null);
        }
        catch (CameraAccessException cameraAccessException) {
            MDLog.e((String)"Camera", (String)("Camera2 lockFocus failed !!!" + cameraAccessException.toString()));
        }
    }

    @Override
    @RequiresApi(api=21)
    public boolean resetCamera(int n, MRConfig mRConfig) {
        this.stopPreview();
        return this.prepare(n, mRConfig);
    }

    @RequiresApi(api=21)
    private boolean isSupportFlashAEMode(int n) {
        block4: {
            CameraCharacteristics cameraCharacteristics = null;
            try {
                if (this.mCameraManager != null) {
                    int[] nArray;
                    cameraCharacteristics = this.mCameraManager.getCameraCharacteristics(String.valueOf(this.mCurrentCamId));
                    for (int n2 : nArray = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_MODES)) {
                        if (n2 != n) continue;
                        return true;
                    }
                }
            }
            catch (CameraAccessException cameraAccessException) {
                MDLog.e((String)"Camera", (String)("Get Camera2 is support flash AE mode error!" + cameraAccessException.getMessage()));
                this.onCameraError(10, CameraErrorMap.ErrorMap.get(10));
                if (this.mOnCameraErrorListener == null) break block4;
                this.mOnCameraErrorListener.onFail(4007, "Get Camera2 is support flash AE mode error!" + cameraAccessException.getMessage());
            }
        }
        return false;
    }

    @Override
    @RequiresApi(api=21)
    public boolean isSupportFlashAutoMode() {
        return this.isSupportFlashAEMode(2);
    }

    @Override
    @RequiresApi(api=21)
    public boolean isSupportFlashOnMode() {
        return this.isSupportFlashAEMode(1);
    }

    @Override
    @RequiresApi(api=21)
    public boolean isSupportFlashTorchMode() {
        return this.flashInfoAvailabel;
    }

    @Override
    @RequiresApi(api=21)
    public void setFlashMode(String string) {
        if (this.flashInfoAvailabel.booleanValue()) {
            if (string.equals("on")) {
                this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)2);
            } else if (string.equals("off")) {
                this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
            } else if (string.equals("auto")) {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_MODE, (Object)1);
            }
            try {
                CaptureRequest captureRequest = this.mPreviewRequestBuilder.build();
                this.mCameraCaptureSession.setRepeatingRequest(captureRequest, null, this.childHandler);
            }
            catch (CameraAccessException cameraAccessException) {
                MDLog.e((String)"Camera", (String)("Set Camera2 is flash mode error!" + cameraAccessException.getMessage()));
                this.onCameraError(11, CameraErrorMap.ErrorMap.get(11));
                if (this.mOnCameraErrorListener != null) {
                    this.mOnCameraErrorListener.onFail(4005, "Set Camera2 is flash mode error!" + cameraAccessException.getMessage());
                }
            }
            catch (IllegalStateException illegalStateException) {
                MDLog.e((String)"Camera", (String)("Set Camera2 is flash mode error!" + illegalStateException.getMessage()));
                this.onCameraError(11, CameraErrorMap.ErrorMap.get(11));
            }
        }
    }

    @Override
    public boolean isSupportExporureAdjust() {
        return false;
    }

    @Override
    public void setExposureCompensation(int n) {
    }

    @Override
    public int getMaxExposureCompensation() {
        return 0;
    }

    @Override
    public int getMinExposureCompensation() {
        return 0;
    }

    @Override
    public void setOnCameraErrorCallback(Camera.ErrorCallback errorCallback) {
    }

    public void setCameraErrorHappend(OnCameraErrorHappend onCameraErrorHappend) {
        this.cameraErrorHappend = onCameraErrorHappend;
    }

    @RequiresApi(api=21)
    public void setCameraContext(Context context) {
        this.managerContex = context;
        if (context != null) {
            this.mCameraManager = (CameraManager)context.getSystemService("camera");
        }
    }

    @Override
    public void setVideoStabilization(boolean bl) {
    }

    @Override
    public com.core.glcore.config.Size getCameraPreviewSize() {
        com.core.glcore.config.Size size = new com.core.glcore.config.Size(this.mrCoreParameters.previewVideoWidth, this.mrCoreParameters.previewVideoHeight);
        return size;
    }

    @Override
    public int[] getCameraFps() {
        return null;
    }

    @Override
    public void setOnDotErrorListener(ICamera.onCameraErrorListener onCameraErrorListener2) {
        this.mOnCameraErrorListener = onCameraErrorListener2;
    }

    public static interface OnCameraErrorHappend {
        public void onCameraError(int var1, String var2);
    }
}

