/*
 * Decompiled with CFR 0.152.
 */
package com.core.glcore.camera;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.Build;
import android.support.annotation.RequiresApi;
import com.core.glcore.camera.ICamera;
import com.core.glcore.config.MRConfig;
import com.core.glcore.config.MRCoreParameters;
import com.core.glcore.config.Rotation;
import com.core.glcore.config.Size;
import com.core.glcore.util.CameraHelper;
import com.core.glcore.util.MathUtil;
import com.core.glcore.util.PreferenceUtil;
import com.mm.mdlog.MDLog;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@RequiresApi(api=14)
public class MCamera
implements ICamera {
    private final Object syncOp = new Object();
    private MRCoreParameters mrCoreParameters;
    private Camera mCamera;
    private int displayOrientation = 0;
    private int cameraRotation = 0;
    private int mCameraCount;
    private int mCurrentCamId = 0;
    private SurfaceTexture mCameraTexture;
    private ICamera.ICameraDataCallback dataCallback;
    private ICamera.onCameraSetListener cameraSetListener;
    Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
    private static boolean cameraIsWorking = false;
    private ICamera.onCameraErrorListener mOnCameraErrorListener = null;
    private static CameraReleaseCallback cameraReleaseCallback = null;

    @RequiresApi(api=9)
    public MCamera(MRCoreParameters mRCoreParameters) {
        this.mrCoreParameters = mRCoreParameters;
        this.mCameraCount = Camera.getNumberOfCameras();
    }

    @Override
    public void setCameraDataCallback(ICamera.ICameraDataCallback iCameraDataCallback) {
        this.dataCallback = iCameraDataCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresApi(api=14)
    public boolean startPreview(SurfaceTexture surfaceTexture) {
        this.mCameraTexture = surfaceTexture;
        if (this.mCamera == null) {
            MDLog.e((String)"Camera", (String)"Camera is NULL");
            return false;
        }
        if (null != this.dataCallback) {
            this.mCamera.setPreviewCallbackWithBuffer(new Camera.PreviewCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onPreviewFrame(byte[] byArray, Camera camera) {
                    Object object = MCamera.this.syncOp;
                    synchronized (object) {
                        if (MCamera.this.dataCallback != null) {
                            MCamera.this.dataCallback.onData(byArray);
                        }
                        if (MCamera.this.mCamera != null) {
                            MCamera.this.mCamera.addCallbackBuffer(byArray);
                        }
                    }
                }
            });
        }
        Object object = this.syncOp;
        synchronized (object) {
            try {
                this.mCamera.setPreviewTexture(this.mCameraTexture);
            }
            catch (IOException iOException) {
                MDLog.e((String)"Camera", (String)("Camera start preview failed !" + iOException.getMessage()));
                this.mCamera.setPreviewCallback(null);
                this.mCamera.setPreviewCallbackWithBuffer(null);
                this.mCamera.release();
                this.mCameraTexture.release();
                this.mCamera = null;
                if (this.mOnCameraErrorListener != null) {
                    this.mOnCameraErrorListener.onFail(4002, "Camera start preview failed !" + iOException.getMessage());
                }
                return false;
            }
            this.mCamera.startPreview();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int stopPreview() {
        if (this.cameraSetListener != null) {
            this.cameraSetListener.onCameraSet(null);
        }
        Object object = this.syncOp;
        synchronized (object) {
            if (this.mCamera != null) {
                try {
                    this.mCamera.stopPreview();
                    this.mCamera.setPreviewCallback(null);
                    this.mCamera.setPreviewCallbackWithBuffer(null);
                    this.mCamera.release();
                    this.mCamera = null;
                }
                catch (Throwable throwable) {
                    MDLog.e((String)"Camera", (String)("Camera stop preview failed !" + throwable.getMessage()));
                    if (this.mOnCameraErrorListener != null) {
                        this.mOnCameraErrorListener.onFail(4003, "Camera stop preview failed !" + throwable.getMessage());
                    }
                    return -1;
                }
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseCamera() {
        Object object = this.syncOp;
        synchronized (object) {
            if (this.mCamera != null) {
                try {
                    this.mCamera.stopPreview();
                }
                catch (Throwable throwable) {
                    MDLog.e((String)"Camera", (String)("Camera pauseCamera failed !" + throwable.getMessage()));
                }
            }
        }
    }

    @Override
    public void resumeCamera() {
        if (null != this.mCamera) {
            if (null != this.dataCallback) {
                this.mCamera.setPreviewCallbackWithBuffer(new Camera.PreviewCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onPreviewFrame(byte[] byArray, Camera camera) {
                        Object object = MCamera.this.syncOp;
                        synchronized (object) {
                            if (MCamera.this.dataCallback != null) {
                                MCamera.this.dataCallback.onData(byArray);
                            }
                            if (MCamera.this.mCamera != null) {
                                MCamera.this.mCamera.addCallbackBuffer(byArray);
                            }
                        }
                    }
                });
            }
            this.mCamera.startPreview();
        }
    }

    @Override
    @RequiresApi(api=9)
    public boolean open() {
        try {
            this.mCamera = Camera.open((int)this.mCurrentCamId);
            cameraIsWorking = true;
        }
        catch (Throwable throwable) {
            MDLog.e((String)"Camera", (String)("Camera open failed !" + throwable.getMessage()));
            if (this.mOnCameraErrorListener != null) {
                this.mOnCameraErrorListener.onFail(4004, "Camera open failed !" + throwable.getMessage());
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prepare(int n, MRConfig mRConfig) {
        int n2;
        if (this.mCameraCount - 1 >= mRConfig.getDefaultCamera()) {
            this.mCurrentCamId = mRConfig.getDefaultCamera();
        }
        Object object = this.syncOp;
        synchronized (object) {
            n2 = 0;
            while (n2 < 2) {
                try {
                    if (!this.open()) {
                        MDLog.e((String)"Camera", (String)"Camera Open Failed!");
                        return false;
                    }
                    if (this.mCamera == null) {
                        MDLog.e((String)"Camera", (String)"Camera is NULL");
                        return false;
                    }
                    this.adjustCameraOrientation(n);
                    break;
                }
                catch (Throwable throwable) {
                    if (++n2 >= 2) {
                        return false;
                    }
                    try {
                        if (this.mCamera == null) continue;
                        this.mCamera.setPreviewCallback(null);
                        this.mCamera.setPreviewCallbackWithBuffer(null);
                        this.mCamera.release();
                        this.mCamera = null;
                    }
                    catch (Throwable throwable2) {}
                }
            }
            try {
                Camera.Parameters parameters = this.mCamera.getParameters();
                CameraHelper.selectCameraPreviewWH(parameters, this.mrCoreParameters, mRConfig.getTargetVideoSize());
                this.mrCoreParameters.videoFPS = mRConfig.getVideoFPS() > this.mrCoreParameters.previewMaxFps / 1000 ? this.mrCoreParameters.previewMaxFps / 1000 : mRConfig.getVideoFPS();
                CameraHelper.selectCameraFpsRange(parameters, this.mrCoreParameters);
                this.resolveResolution(this.mrCoreParameters, mRConfig.getTargetVideoSize());
                if (!CameraHelper.selectCameraColorFormat(parameters, this.mrCoreParameters)) {
                    MDLog.e((String)"Camera", (String)"CameraHelper.selectCameraColorFormat,Failed");
                    if (this.mOnCameraErrorListener != null) {
                        this.mOnCameraErrorListener.onFail(4006, "CameraHelper.selectCameraColorFormat,Failed");
                    }
                    this.mrCoreParameters.dump();
                    return false;
                }
                if (!CameraHelper.configCamera(this.mCamera, this.mrCoreParameters)) {
                    MDLog.e((String)"Camera", (String)"CameraHelper.configCamera,Failed");
                    if (this.mOnCameraErrorListener != null) {
                        this.mOnCameraErrorListener.onFail(4005, "CameraHelper.configCamera,Failed");
                    }
                    this.mrCoreParameters.dump();
                    return false;
                }
                this.prepareCallbackBuffer(this.mrCoreParameters);
            }
            catch (Exception exception) {
                MDLog.e((String)"Camera", (String)("CameraHelper.prepare failed !" + exception.getMessage()));
                if (this.mOnCameraErrorListener != null) {
                    this.mOnCameraErrorListener.onFail(4001, "CameraHelper.prepare failed !" + exception.getMessage());
                }
                return false;
            }
        }
        n2 = this.mrCoreParameters.previewVideoWidth;
        int n3 = this.mrCoreParameters.previewVideoHeight;
        if (mRConfig.getScaleMode() == 1) {
            n2 = (int)((float)n3 * mRConfig.getScaleRatio());
            if (n2 != this.mrCoreParameters.previewVideoWidth) {
                n2 = n2 >> 4 << 4;
            }
        } else if (mRConfig.getScaleMode() == 0 && (n3 = (int)((float)n2 / mRConfig.getScaleRatio())) != this.mrCoreParameters.previewVideoHeight) {
            n3 = n3 >> 4 << 4;
        }
        object = this.cameraRotation == 1 || this.cameraRotation == 3 ? new Size(n3, n2) : new Size(n2, n3);
        if (this.mrCoreParameters.useDefaultEncodeSize) {
            if (object != null && ((Size)object).getWidth() > 0 && ((Size)object).getHeight() > 0) {
                this.mrCoreParameters.encodeWidth = ((Size)object).getWidth();
                this.mrCoreParameters.encodeHeight = ((Size)object).getHeight();
                mRConfig.setEncodeSize((Size)object);
            }
        } else {
            object = mRConfig.getEncodeSize();
            if (object != null && ((Size)object).getWidth() > 0 && ((Size)object).getHeight() > 0) {
                this.mrCoreParameters.encodeWidth = ((Size)object).getWidth();
                this.mrCoreParameters.encodeHeight = ((Size)object).getHeight();
            }
        }
        if (this.cameraSetListener != null) {
            this.cameraSetListener.onCameraSet(this.mCamera);
        }
        return true;
    }

    @Override
    public int getDisplayOrientation() {
        return this.displayOrientation;
    }

    @Override
    public int getCameraRotation() {
        return this.cameraRotation * 90;
    }

    private void resolveResolution(MRCoreParameters mRCoreParameters, Size size) {
        if (mRCoreParameters.filterMode == 2) {
            if (mRCoreParameters.isPortrait) {
                // empty if block
            }
        } else {
            float f;
            float f2;
            if (mRCoreParameters.isPortrait) {
                f2 = mRCoreParameters.previewVideoHeight;
                f = mRCoreParameters.previewVideoWidth;
            } else {
                f2 = mRCoreParameters.previewVideoWidth;
                f = mRCoreParameters.previewVideoHeight;
            }
            float f3 = mRCoreParameters.videoWidth;
            float f4 = mRCoreParameters.videoHeight;
            float f5 = f / f2;
            float f6 = f4 / f3;
            mRCoreParameters.cropRatio = f5 == f6 ? 0.0f : (f5 > f6 ? (1.0f - f6 / f5) / 2.0f : -(1.0f - f5 / f6) / 2.0f);
        }
        mRCoreParameters.previewBufferSize = mRCoreParameters.previewVideoWidth * mRCoreParameters.previewVideoHeight * 3 / 2;
    }

    private void prepareCallbackBuffer(MRCoreParameters mRCoreParameters) {
        for (int i = 0; i < mRCoreParameters.previewBufferCount; ++i) {
            this.mCamera.addCallbackBuffer(new byte[mRCoreParameters.previewBufferSize]);
        }
    }

    @Override
    public void adjustCameraOrientation(int n) {
        if (this.mCamera == null) {
            MDLog.e((String)"Camera", (String)"\u8bf7\u5148\u6253\u5f00Camera!");
            return;
        }
        this.displayOrientation = CameraHelper.determineDisplayOrientation(n, this.mCurrentCamId);
        Rotation rotation = Rotation.NORMAL;
        switch (this.displayOrientation) {
            case 90: {
                rotation = Rotation.ROTATION_90;
                break;
            }
            case 180: {
                rotation = Rotation.ROTATION_180;
                break;
            }
            case 270: {
                rotation = Rotation.ROTATION_270;
            }
        }
        this.cameraRotation = this.mCurrentCamId == 1 ? rotation.ordinal() % (Rotation.ROTATION_270.ordinal() + 1) : rotation.ordinal() % (Rotation.ROTATION_270.ordinal() + 1);
        this.mCamera.setDisplayOrientation(this.displayOrientation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean switchCamera(int n, MRConfig mRConfig) {
        Object object = this.syncOp;
        synchronized (object) {
            MDLog.i((String)"Camera", (String)"Swap camera");
            if (this.mCamera != null) {
                this.mCamera.stopPreview();
                this.mCamera.setPreviewCallback(null);
                this.mCamera.setPreviewCallbackWithBuffer(null);
                this.mCamera.release();
                this.mCamera = null;
            }
            this.mCurrentCamId = (this.mCurrentCamId + 1) % this.mCameraCount;
            mRConfig.setDefaultCamera(this.mCurrentCamId);
            this.prepare(n, mRConfig);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresApi(api=8)
    public void release() {
        Object object = this.syncOp;
        synchronized (object) {
            if (this.mCamera != null) {
                this.mCamera.setPreviewCallback(null);
                this.mCamera.setPreviewCallbackWithBuffer(null);
                this.mCamera.release();
                this.mCamera = null;
            }
        }
        MCamera.callReleaseCallback();
        cameraIsWorking = false;
    }

    @Override
    public boolean isFront() {
        boolean bl = false;
        try {
            Camera.getCameraInfo((int)this.mCurrentCamId, (Camera.CameraInfo)this.cameraInfo);
            bl = true;
        }
        catch (Exception exception) {
            MDLog.printErrStackTrace((String)"Camera", (Throwable)exception);
            if (this.mOnCameraErrorListener != null) {
                this.mOnCameraErrorListener.onFail(4007, "Get camera is front error!" + exception.getMessage());
            }
            bl = false;
        }
        return this.mCurrentCamId == 1 || bl && this.cameraInfo.facing == 1;
    }

    @Override
    public boolean isSupportFlashMode() {
        boolean bl = false;
        try {
            if (this.mCamera != null) {
                Camera.Parameters parameters = this.mCamera.getParameters();
                List list = parameters.getSupportedFlashModes();
                if (null == list) {
                    return false;
                }
                for (String string : list) {
                    if (!string.equals("torch")) continue;
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            if (this.mOnCameraErrorListener != null) {
                this.mOnCameraErrorListener.onFail(4007, "Get camera is front error!" + exception.getMessage());
            }
            MDLog.e((String)"Camera", (String)exception.getMessage());
        }
        return bl;
    }

    @Override
    public void openTorch() {
        try {
            if (null != this.mCamera) {
                Camera.Parameters parameters = this.mCamera.getParameters();
                parameters.setFlashMode("torch");
                this.mCamera.setParameters(parameters);
            }
        }
        catch (Exception exception) {
            if (this.mOnCameraErrorListener != null) {
                this.mOnCameraErrorListener.onFail(4005, "Open camera flash mode torch error!" + exception.getMessage());
            }
            MDLog.e((String)"Camera", (String)exception.getMessage());
        }
    }

    @Override
    public void closeTorch() {
        try {
            if (null != this.mCamera) {
                Camera.Parameters parameters = this.mCamera.getParameters();
                parameters.getSupportedFlashModes();
                parameters.setFlashMode("off");
                this.mCamera.setParameters(parameters);
            }
        }
        catch (Exception exception) {
            if (this.mOnCameraErrorListener != null) {
                this.mOnCameraErrorListener.onFail(4005, "Set camera flash mode torch error!" + exception.getMessage());
            }
            MDLog.e((String)"Camera", (String)exception.getMessage());
        }
    }

    @Override
    public boolean isSupportZoom() {
        boolean bl = true;
        try {
            if (this.mCamera.getParameters().isSmoothZoomSupported()) {
                bl = false;
            }
        }
        catch (Exception exception) {
            if (this.mOnCameraErrorListener != null) {
                this.mOnCameraErrorListener.onFail(4007, "Get camera is support zoom error!" + exception.getMessage());
            }
            MDLog.e((String)"Camera", (String)exception.getMessage());
        }
        return bl;
    }

    @Override
    public int getMaxZoomLevel() {
        try {
            if (null != this.mCamera) {
                return this.mCamera.getParameters() != null ? this.mCamera.getParameters().getMaxZoom() - 1 : 0;
            }
            return 0;
        }
        catch (Exception exception) {
            if (this.mOnCameraErrorListener != null) {
                this.mOnCameraErrorListener.onFail(4007, "Get camera max support zoom level error!" + exception.getMessage());
            }
            MDLog.e((String)"Camera", (String)exception.getMessage());
            return 0;
        }
    }

    @Override
    public int getCurrentZoomLevel() {
        try {
            return this.mCamera.getParameters() != null ? this.mCamera.getParameters().getZoom() : 0;
        }
        catch (Exception exception) {
            if (this.mOnCameraErrorListener != null) {
                this.mOnCameraErrorListener.onFail(4007, "Get camera current zoom level error!" + exception.getMessage());
            }
            MDLog.e((String)"Camera", (String)exception.getMessage());
            return 0;
        }
    }

    @Override
    public void setZoomLevel(int n) {
        MDLog.i((String)"Camera", (String)("level" + n));
        try {
            if (this.mCamera.getParameters() == null || this.mCamera == null) {
                return;
            }
            if (n >= this.mCamera.getParameters().getMaxZoom()) {
                n = 0;
            }
            if (this.mCamera.getParameters().isZoomSupported()) {
                Camera.Parameters parameters = this.mCamera.getParameters();
                parameters.setZoom(n);
                this.mCamera.setParameters(parameters);
            }
        }
        catch (Exception exception) {
            MDLog.e((String)"Camera", (String)("Set camera zoom level error!" + exception.getMessage()));
            if (this.mOnCameraErrorListener != null) {
                this.mOnCameraErrorListener.onFail(4005, "Set camera zoom level error!" + exception.getMessage());
            }
        }
        catch (Error error) {
            MDLog.e((String)"Camera", (String)("Set camera zoom level error!" + error.getMessage()));
            if (this.mOnCameraErrorListener != null) {
                this.mOnCameraErrorListener.onFail(4005, "Set camera zoom level error!" + error.getMessage());
            }
            error.printStackTrace();
        }
    }

    private Rect calculateTapArea(float f, float f2, float f3, float f4, float f5) {
        float f6 = 100.0f;
        int n = Float.valueOf(f6 * f5).intValue();
        int n2 = (int)(f4 / f2 * 2000.0f - 1000.0f);
        int n3 = (int)((f - f3) / f * 2000.0f - 1000.0f);
        if (this.isFront()) {
            n2 = (int)((f2 - f4) / f2 * 2000.0f - 1000.0f);
            n3 = (int)((f - f3) / f * 2000.0f - 1000.0f);
        }
        int n4 = MathUtil.clamp(n2 - n / 2, -1000, 1000);
        int n5 = MathUtil.clamp(n4 + n, -1000, 1000);
        int n6 = MathUtil.clamp(n3 - n / 2, -1000, 1000);
        int n7 = MathUtil.clamp(n6 + n, -1000, 1000);
        return new Rect(n4, n6, n5, n7);
    }

    @Override
    public void focusOnTouch(double d, double d2, int n, int n2) {
        Rect rect = this.calculateTapArea(n, n2, (float)d, (float)d2, 1.0f);
        this.focusOnRect(rect, null);
    }

    @Override
    public void focusOnRect(Rect rect, Camera.AutoFocusCallback autoFocusCallback) {
        if (null == this.mCamera) {
            return;
        }
        try {
            this.mCamera.cancelAutoFocus();
        }
        catch (Exception exception) {
            MDLog.e((String)"Camera", (String)exception.getMessage());
            return;
        }
        Camera.Parameters parameters = null;
        String string = "auto";
        try {
            parameters = this.mCamera.getParameters();
        }
        catch (RuntimeException runtimeException) {
            parameters = null;
        }
        if (null == parameters) {
            return;
        }
        if (!this.isSupportAutoFocus(parameters)) {
            if (!this.isSupportFixedFocus(parameters) && !this.isFront()) {
                return;
            }
            string = "continuous-video";
        }
        ArrayList<Camera.Area> arrayList = new ArrayList<Camera.Area>();
        ArrayList<Camera.Area> arrayList2 = new ArrayList<Camera.Area>();
        arrayList.add(new Camera.Area(rect, 1000));
        arrayList2.add(new Camera.Area(rect, 1000));
        if (!this.isFront()) {
            parameters.setFocusMode(string);
            parameters.setFocusAreas(arrayList);
        }
        if (parameters.getMaxNumMeteringAreas() > 0) {
            parameters.setMeteringAreas(arrayList2);
        }
        try {
            this.mCamera.setParameters(parameters);
            if (!this.isFront()) {
                this.mCamera.autoFocus(autoFocusCallback);
            }
        }
        catch (Exception exception) {
            if (this.mOnCameraErrorListener != null) {
                this.mOnCameraErrorListener.onFail(4005, "Set camera autoFocus error!" + exception.getMessage());
            }
            MDLog.e((String)"Camera", (String)exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOnCameraSetListener(ICamera.onCameraSetListener onCameraSetListener2) {
        Object object = this.syncOp;
        synchronized (object) {
            this.cameraSetListener = onCameraSetListener2;
        }
    }

    @Override
    public void takePicture(String string) {
        this.mCamera.takePicture(null, new Camera.PictureCallback(){

            public void onPictureTaken(byte[] byArray, Camera camera) {
            }
        }, new Camera.PictureCallback(){

            public void onPictureTaken(byte[] byArray, Camera camera) {
                block2: {
                    try {
                        camera.startPreview();
                    }
                    catch (Exception exception) {
                        MDLog.e((String)"Camera", (String)("Camera take photo failed !!!" + exception.toString()));
                        if (MCamera.this.mOnCameraErrorListener == null) break block2;
                        MCamera.this.mOnCameraErrorListener.onFail(4009, "Camera take photo failed !!!" + exception.toString());
                    }
                }
            }
        });
    }

    @Override
    public boolean isSupportFlashAutoMode() {
        boolean bl = false;
        try {
            if (this.mCamera != null) {
                Camera.Parameters parameters = this.mCamera.getParameters();
                List list = parameters.getSupportedFlashModes();
                if (null == list) {
                    return false;
                }
                for (String string : list) {
                    if (!string.equals("auto")) continue;
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            if (this.mOnCameraErrorListener != null) {
                this.mOnCameraErrorListener.onFail(4007, "Get camera is Support Flash Auto Mode error!" + exception.getMessage());
            }
            MDLog.e((String)"Camera", (String)("Get camera is Support Flash Auto Mode error!" + exception.toString()));
        }
        return bl;
    }

    @Override
    public boolean isSupportFlashOnMode() {
        boolean bl;
        block5: {
            bl = false;
            boolean bl2 = false;
            try {
                if (this.mCamera != null) {
                    Camera.Parameters parameters = this.mCamera.getParameters();
                    List list = parameters.getSupportedFlashModes();
                    if (null == list) {
                        return false;
                    }
                    for (String string : list) {
                        if (!string.equals("on")) continue;
                        bl = true;
                    }
                }
            }
            catch (Exception exception) {
                MDLog.e((String)"Camera", (String)("Get camera is Support Flash Mode error!" + exception.getMessage()));
                if (this.mOnCameraErrorListener == null) break block5;
                this.mOnCameraErrorListener.onFail(4007, "Get camera is Support Flash Mode error!" + exception.getMessage());
            }
        }
        return bl;
    }

    @Override
    public boolean isSupportFlashTorchMode() {
        boolean bl = false;
        try {
            if (this.mCamera != null) {
                Camera.Parameters parameters = this.mCamera.getParameters();
                List list = parameters.getSupportedFlashModes();
                if (null == list) {
                    return false;
                }
                for (String string : list) {
                    if (!string.equals("torch")) continue;
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            if (this.mOnCameraErrorListener != null) {
                this.mOnCameraErrorListener.onFail(4007, "Get camera is Support Flash Torch Mode error!" + exception.getMessage());
            }
            MDLog.e((String)"Camera", (String)("Get camera is Support Flash Torch Mode error!" + exception.getMessage()));
        }
        return bl;
    }

    @Override
    public void setFlashMode(String string) {
        try {
            if (null != this.mCamera) {
                Camera.Parameters parameters = this.mCamera.getParameters();
                List list = parameters.getSupportedFlashModes();
                if (null == list) {
                    return;
                }
                if (list.contains(string)) {
                    parameters.setFlashMode(string);
                    this.mCamera.setParameters(parameters);
                }
            }
        }
        catch (Exception exception) {
            if (this.mOnCameraErrorListener != null) {
                this.mOnCameraErrorListener.onFail(4005, "Set camera flash Mode error!" + exception.getMessage());
            }
            MDLog.e((String)"Camera", (String)("Set camera flash Mode error!" + exception.getMessage()));
        }
    }

    @Override
    public boolean isSupportExporureAdjust() {
        try {
            if (null != this.mCamera) {
                Camera.Parameters parameters = this.mCamera.getParameters();
                return parameters.isAutoExposureLockSupported();
            }
            return false;
        }
        catch (Exception exception) {
            if (this.mOnCameraErrorListener != null) {
                this.mOnCameraErrorListener.onFail(4007, "Get camera is Support Exporure Adjust error!" + exception.getMessage());
            }
            MDLog.e((String)"Camera", (String)("Get camera is Support Exporure Adjust error!" + exception.getMessage()));
            return false;
        }
    }

    @Override
    public void setExposureCompensation(int n) {
        try {
            if (null != this.mCamera) {
                Camera.Parameters parameters = this.mCamera.getParameters();
                if (n > this.getMaxExposureCompensation()) {
                    n = this.getMaxExposureCompensation();
                }
                if (n < this.getMinExposureCompensation()) {
                    n = this.getMinExposureCompensation();
                }
                parameters.setExposureCompensation(n);
                this.mCamera.setParameters(parameters);
            }
        }
        catch (Exception exception) {
            if (this.mOnCameraErrorListener != null) {
                this.mOnCameraErrorListener.onFail(4005, "Set camera Exposure Compensation error!" + exception.getMessage());
            }
            MDLog.e((String)"Camera", (String)("Set camera Exposure Compensation error!" + exception.getMessage()));
        }
    }

    @Override
    public int getMaxExposureCompensation() {
        try {
            if (null != this.mCamera) {
                Camera.Parameters parameters = this.mCamera.getParameters();
                return parameters.getMaxExposureCompensation();
            }
        }
        catch (Exception exception) {
            if (this.mOnCameraErrorListener != null) {
                this.mOnCameraErrorListener.onFail(4007, "Get camera Max Exposure Compensation error!" + exception.getMessage());
            }
            MDLog.e((String)"Camera", (String)("Get camera Max Exposure Compensation error!" + exception.getMessage()));
        }
        return 0;
    }

    @Override
    public int getMinExposureCompensation() {
        try {
            if (null != this.mCamera) {
                Camera.Parameters parameters = this.mCamera.getParameters();
                return parameters.getMinExposureCompensation();
            }
        }
        catch (Exception exception) {
            if (this.mOnCameraErrorListener != null) {
                this.mOnCameraErrorListener.onFail(4007, "Get camera Min Exposure Compensation error!" + exception.getMessage());
            }
            MDLog.e((String)"Camera", (String)("Get camera Min Exposure Compensation error!" + exception.getMessage()));
        }
        return 0;
    }

    public void setPreviewTexture(SurfaceTexture surfaceTexture) {
        if (null != this.mCamera) {
            this.mCamera.setPreviewTexture(surfaceTexture);
            MDLog.i((String)"Camera", (String)"Set camera preview texture !!!");
        }
    }

    private boolean isSupportAutoFocus(Camera.Parameters parameters) {
        List list = parameters.getSupportedFocusModes();
        if (list == null) {
            return false;
        }
        for (String string : list) {
            if (!string.equals("auto")) continue;
            return true;
        }
        return false;
    }

    private boolean isSupportFixedFocus(Camera.Parameters parameters) {
        List list = parameters.getSupportedFocusModes();
        if (list == null) {
            return false;
        }
        for (String string : list) {
            if (!string.equals("fixed")) continue;
            return true;
        }
        return false;
    }

    private boolean isSupportWhiteBalance(Camera.Parameters parameters) {
        List list = parameters.getSupportedWhiteBalance();
        if (list == null) {
            return false;
        }
        for (String string : list) {
            if (!string.equals("auto")) continue;
            return true;
        }
        return false;
    }

    public void setVideoStabilization(Camera.Parameters parameters) {
        if (Build.VERSION.SDK_INT >= 15) {
            if (parameters.isVideoStabilizationSupported()) {
                if (parameters.getVideoStabilization()) {
                    return;
                }
                parameters.setVideoStabilization(true);
            }
        } else {
            return;
        }
    }

    @Override
    public void setVideoStabilization(boolean bl) {
        try {
            Camera.Parameters parameters;
            if (Build.VERSION.SDK_INT >= 15 && (parameters = this.mCamera.getParameters()).isVideoStabilizationSupported() && parameters.getVideoStabilization() != bl) {
                parameters.setVideoStabilization(bl);
                this.mCamera.setParameters(parameters);
            }
        }
        catch (Exception exception) {
            if (this.mOnCameraErrorListener != null) {
                this.mOnCameraErrorListener.onFail(4005, "Set camera Video Stabilization error!" + exception.getMessage());
            }
            MDLog.e((String)"Camera", (String)("Set camera Video Stabilization error!" + exception.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean resetCamera(int n, MRConfig mRConfig) {
        try {
            Object object = this.syncOp;
            synchronized (object) {
                MDLog.i((String)"Camera", (String)"Reset camera");
                if (this.mCamera != null) {
                    this.mCamera.stopPreview();
                    this.mCamera.setPreviewCallback(null);
                    this.mCamera.setPreviewCallbackWithBuffer(null);
                    this.mCamera.release();
                    this.mCamera = null;
                }
                mRConfig.setDefaultCamera(this.mCurrentCamId);
                this.prepare(n, mRConfig);
            }
        }
        catch (Exception exception) {
            MDLog.e((String)"Camera", (String)("Reset camera failed !!!" + exception.toString()));
        }
        return false;
    }

    @Override
    public void setOnCameraErrorCallback(Camera.ErrorCallback errorCallback) {
        if (this.mCamera != null) {
            this.mCamera.setErrorCallback(errorCallback);
        }
    }

    public static List<Size> getCameraSupportList(Context context, int n) {
        return MCamera.getCameraSupportList(context, null, n, -1, -1.0f);
    }

    public static List<Size> getCameraSupportList(Context context, Size size, int n, int n2, float f) {
        ArrayList<Size> arrayList = new ArrayList<Size>();
        List<Object> list = null;
        if (MCamera.getLocalCameraSizes(context, arrayList, Integer.toString(n))) {
            return arrayList;
        }
        try {
            Object object;
            Camera camera;
            List list2 = null;
            ArrayList arrayList2 = null;
            if ((n & 2) != 0) {
                camera = Camera.open((int)0);
                object = camera.getParameters();
                arrayList2 = object.getSupportedPreviewSizes();
                list = arrayList2;
                camera.release();
                Collections.sort(arrayList2, new Comparator<Camera.Size>(){

                    @Override
                    public int compare(Camera.Size size, Camera.Size size2) {
                        if (size.width * size.height > size2.width * size2.height) {
                            return 1;
                        }
                        return -1;
                    }
                });
                for (Camera.Size size2 : arrayList2) {
                    MDLog.i((String)"Camera", (String)("Back width = " + size2.width + " height = " + size2.height));
                }
            }
            if ((n & 1) != 0) {
                camera = Camera.open((int)1);
                object = camera.getParameters();
                list2 = object.getSupportedPreviewSizes();
                list = list2;
                camera.release();
                Collections.sort(list2, new Comparator<Camera.Size>(){

                    @Override
                    public int compare(Camera.Size size, Camera.Size size2) {
                        if (size.width * size.height > size2.width * size2.height) {
                            return 1;
                        }
                        return -1;
                    }
                });
                for (Camera.Size size2 : list2) {
                    MDLog.i((String)"Camera", (String)("Front width = " + size2.width + " height = " + size2.height));
                }
            }
            if (n == 3) {
                list = new ArrayList();
                for (Object object2 : arrayList2) {
                    for (Object object3 : list2) {
                        if (((Camera.Size)object2).width != ((Camera.Size)object3).width || ((Camera.Size)object2).height != ((Camera.Size)object3).height) continue;
                        list.add(object2);
                    }
                }
            }
            if (n2 > 0 && f > 0.0f && size != null && list.size() > 0) {
                int n3 = size.getWidth() * size.getHeight();
                int n4 = 0;
                int n5 = 0;
                for (Camera.Size size3 : list) {
                    int n6 = size3.width * size3.height - size.getWidth() * size.getHeight();
                    if (n2 != 0 ? n2 == 1 && (float)size3.height * f > (float)size3.width : (float)size3.width / f > (float)size3.height) continue;
                    if (Math.abs(n6) < n3) {
                        if (size3.width > size.getWidth() && size3.height > size.getHeight()) continue;
                        n3 = Math.abs(n6);
                        n4 = size3.width;
                        n5 = size3.height;
                        continue;
                    }
                    if (Math.abs(n6) != n3 || n4 >= size3.width) continue;
                    n4 = size3.width;
                    n5 = size3.height;
                }
                if (n4 != 0 && n5 != 0) {
                    arrayList.add(new Size(n4, n5));
                }
            } else if (size == null) {
                for (Object object2 : list) {
                    MDLog.i((String)"Camera", (String)("Both width = " + ((Camera.Size)object2).width + " height = " + ((Camera.Size)object2).height));
                    arrayList.add(new Size(((Camera.Size)object2).width, ((Camera.Size)object2).height));
                }
                Collections.sort(list, new Comparator<Camera.Size>(){

                    @Override
                    public int compare(Camera.Size size, Camera.Size size2) {
                        if (size.width * size.height > size2.width * size2.height) {
                            return 1;
                        }
                        return -1;
                    }
                });
            }
        }
        catch (Throwable throwable) {
            return null;
        }
        MCamera.saveCameraSupportSize(context, arrayList, Integer.toString(n));
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean getLocalCameraSizes(Context context, List<Size> list, String string) {
        String string2 = PreferenceUtil.getDefault(context).getString(string, null);
        try {
            if (string2 != null) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(string2.getBytes(Charset.forName("utf8"))), Charset.forName("utf8")));
                try {
                    String string3 = null;
                    while ((string3 = bufferedReader.readLine()) != null) {
                        String[] stringArray = string3.split(",");
                        Size size = new Size(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
                        list.add(size);
                    }
                }
                catch (Exception exception) {
                    MDLog.e((String)"Camera", (String)("Read camera support resolution failed !!!" + exception.toString()));
                    boolean bl = false;
                    return bl;
                }
                finally {
                    bufferedReader.close();
                    return true;
                }
            }
        }
        catch (Exception exception) {
            MDLog.e((String)"Camera", (String)("Read camera support resolution failed !!!" + exception.toString()));
            return false;
        }
        return false;
    }

    private static void saveCameraSupportSize(Context context, List<Size> list, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Size size : list) {
            stringBuilder.append(size.getWidth() + "," + size.getHeight() + "\r\n");
        }
        PreferenceUtil.getEditor(context).putString(string, stringBuilder.toString()).commit();
    }

    public static boolean isCameraWorking() {
        return cameraIsWorking;
    }

    public static synchronized void setCameraReleaseCallback(CameraReleaseCallback cameraReleaseCallback) {
        MCamera.cameraReleaseCallback = cameraReleaseCallback;
    }

    public static synchronized void callReleaseCallback() {
        if (cameraReleaseCallback != null) {
            cameraReleaseCallback.onCameraRelease();
        }
    }

    @Override
    public Size getCameraPreviewSize() {
        Size size = new Size(this.mrCoreParameters.previewVideoWidth, this.mrCoreParameters.previewVideoHeight);
        return size;
    }

    @Override
    public int[] getCameraFps() {
        if (this.mrCoreParameters != null) {
            int[] nArray = new int[]{this.mrCoreParameters.previewMinFps / 1000, this.mrCoreParameters.previewMaxFps / 1000};
            return nArray;
        }
        return null;
    }

    @Override
    public void setOnDotErrorListener(ICamera.onCameraErrorListener onCameraErrorListener2) {
        this.mOnCameraErrorListener = onCameraErrorListener2;
    }

    public static interface CameraReleaseCallback {
        public void onCameraRelease();
    }
}

