/*
 * Decompiled with CFR 0.152.
 */
package com.core.glcore.camera;

import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.media.Image;
import android.support.annotation.RequiresApi;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ImageReaderUtils {
    public static final int YUV420P = 35;
    public static final int NV21 = 17;
    private static final String TAG = "ImageUtil";
    public static final int COLOR_FormatI420 = 1;
    public static final int COLOR_FormatNV21 = 2;
    private static byte[] rowData = null;

    @RequiresApi(api=19)
    public static byte[] getBytesFromImageAsType(Image image, int n, byte[] byArray) {
        try {
            int n2;
            long l = System.currentTimeMillis();
            Image.Plane[] planeArray = image.getPlanes();
            int n3 = image.getWidth();
            int n4 = image.getHeight();
            byte[] byArray2 = null;
            byArray2 = byArray == null || byArray.length != n3 * n4 * ImageFormat.getBitsPerPixel((int)35) / 8 ? new byte[n3 * n4 * ImageFormat.getBitsPerPixel((int)35) / 8] : byArray;
            l = System.currentTimeMillis();
            int n5 = 0;
            byte[] byArray3 = new byte[n3 * n4 / 4];
            byte[] byArray4 = new byte[n3 * n4 / 4];
            int n6 = 0;
            int n7 = 0;
            for (n2 = 0; n2 < planeArray.length; ++n2) {
                int n8;
                int n9 = planeArray[n2].getPixelStride();
                int n10 = planeArray[n2].getRowStride();
                ByteBuffer byteBuffer = planeArray[n2].getBuffer();
                byte[] byArray5 = new byte[byteBuffer.capacity()];
                byteBuffer.get(byArray5);
                int n11 = 0;
                if (n2 == 0) {
                    long l2 = System.currentTimeMillis();
                    for (int i = 0; i < n4; ++i) {
                        System.arraycopy(byArray5, n11, byArray2, n5, n3);
                        n11 += n10;
                        n5 += n3;
                    }
                    continue;
                }
                if (n2 == 1) {
                    for (int i = 0; i < n4 / 2; ++i) {
                        for (n8 = 0; n8 < n3 / 2; ++n8) {
                            byArray3[n6++] = byArray5[n11];
                            n11 += n9;
                        }
                        if (n9 == 2) {
                            n11 += n10 - n3;
                            continue;
                        }
                        if (n9 != 1) continue;
                        n11 += n10 - n3 / 2;
                    }
                    continue;
                }
                if (n2 != 2) continue;
                for (int i = 0; i < n4 / 2; ++i) {
                    for (n8 = 0; n8 < n3 / 2; ++n8) {
                        byArray4[n7++] = byArray5[n11];
                        n11 += n9;
                    }
                    if (n9 == 2) {
                        n11 += n10 - n3;
                        continue;
                    }
                    if (n9 != 1) continue;
                    n11 += n10 - n3 / 2;
                }
            }
            l = System.currentTimeMillis();
            switch (n) {
                case 35: {
                    System.arraycopy(byArray3, 0, byArray2, n5, byArray3.length);
                    System.arraycopy(byArray4, 0, byArray2, n5 + byArray3.length, byArray4.length);
                    break;
                }
                case 17: {
                    for (n2 = 0; n2 < byArray4.length; ++n2) {
                        byArray2[n5++] = byArray4[n2];
                        byArray2[n5++] = byArray3[n2];
                    }
                    break;
                }
            }
            l = System.currentTimeMillis();
            return byArray2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static boolean isImageFormatSupported(Image image) {
        int n = image.getFormat();
        switch (n) {
            case 17: 
            case 35: 
            case 842094169: {
                return true;
            }
        }
        return false;
    }

    @RequiresApi(api=19)
    public static byte[] getDataFromImage(Image image, int n, byte[] byArray) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("only support COLOR_FormatI420 and COLOR_FormatNV21");
        }
        if (!ImageReaderUtils.isImageFormatSupported(image)) {
            throw new RuntimeException("can't convert Image to byte array, format " + image.getFormat());
        }
        Rect rect = image.getCropRect();
        int n2 = image.getFormat();
        int n3 = rect.width();
        int n4 = rect.height();
        Image.Plane[] planeArray = image.getPlanes();
        byte[] byArray2 = null;
        byArray2 = byArray == null || byArray.length != n3 * n4 * ImageFormat.getBitsPerPixel((int)n2) / 8 ? new byte[n3 * n4 * ImageFormat.getBitsPerPixel((int)n2) / 8] : byArray;
        if (rowData == null || rowData.length != planeArray[0].getRowStride()) {
            rowData = new byte[planeArray[0].getRowStride()];
        }
        int n5 = 0;
        int n6 = 1;
        for (int i = 0; i < planeArray.length; ++i) {
            switch (i) {
                case 0: {
                    n5 = 0;
                    n6 = 1;
                    break;
                }
                case 1: {
                    if (n == 1) {
                        n5 = n3 * n4;
                        n6 = 1;
                        break;
                    }
                    if (n != 2) break;
                    n5 = n3 * n4 + 1;
                    n6 = 2;
                    break;
                }
                case 2: {
                    if (n == 1) {
                        n5 = (int)((double)(n3 * n4) * 1.25);
                        n6 = 1;
                        break;
                    }
                    if (n != 2) break;
                    n5 = n3 * n4;
                    n6 = 2;
                }
            }
            ByteBuffer byteBuffer = planeArray[i].getBuffer();
            int n7 = planeArray[i].getRowStride();
            int n8 = planeArray[i].getPixelStride();
            int n9 = i == 0 ? 0 : 1;
            int n10 = n3 >> n9;
            int n11 = n4 >> n9;
            byteBuffer.position(n7 * (rect.top >> n9) + n8 * (rect.left >> n9));
            for (int j = 0; j < n11; ++j) {
                int n12;
                if (n8 == 1 && n6 == 1) {
                    n12 = n10;
                    byteBuffer.get(byArray2, n5, n12);
                    n5 += n12;
                } else {
                    n12 = (n10 - 1) * n8 + 1;
                    byteBuffer.get(rowData, 0, n12);
                    for (int k = 0; k < n10; ++k) {
                        byArray2[n5] = rowData[k * n8];
                        n5 += n6;
                    }
                }
                if (j >= n11 - 1) continue;
                byteBuffer.position(byteBuffer.position() + n7 - n12);
            }
        }
        return byArray2;
    }

    public static void writeFileToLocal(String string, byte[] byArray) {
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

