/*
 * Decompiled with CFR 0.152.
 */
package com.core.glcore.camera;

import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import com.core.glcore.config.MRConfig;
import com.core.glcore.config.Size;

public interface ICamera {
    public static final int CAMERA_FRONT = 1;
    public static final int CAMERA_BACK = 2;

    public void setOnDotErrorListener(onCameraErrorListener var1);

    public void setCameraDataCallback(ICameraDataCallback var1);

    public boolean startPreview(SurfaceTexture var1);

    public int stopPreview();

    public void pauseCamera();

    public void resumeCamera();

    public boolean open();

    public boolean prepare(int var1, MRConfig var2);

    public int getDisplayOrientation();

    public int getCameraRotation();

    public void adjustCameraOrientation(int var1);

    public boolean switchCamera(int var1, MRConfig var2);

    public void release();

    public boolean isFront();

    public boolean isSupportFlashMode();

    public void openTorch();

    public void closeTorch();

    public boolean isSupportZoom();

    public void setZoomLevel(int var1);

    public int getCurrentZoomLevel();

    public int getMaxZoomLevel();

    public void focusOnRect(Rect var1, Camera.AutoFocusCallback var2);

    public void focusOnTouch(double var1, double var3, int var5, int var6);

    public void setOnCameraSetListener(onCameraSetListener var1);

    public void takePicture(String var1);

    public boolean resetCamera(int var1, MRConfig var2);

    public boolean isSupportFlashAutoMode();

    public boolean isSupportFlashOnMode();

    public boolean isSupportFlashTorchMode();

    public void setFlashMode(String var1);

    public boolean isSupportExporureAdjust();

    public void setExposureCompensation(int var1);

    public int getMaxExposureCompensation();

    public int getMinExposureCompensation();

    public void setOnCameraErrorCallback(Camera.ErrorCallback var1);

    public void setVideoStabilization(boolean var1);

    public Size getCameraPreviewSize();

    public int[] getCameraFps();

    public static interface onCameraErrorListener {
        public void onFail(int var1, String var2);
    }

    public static interface ICameraDataCallback {
        public void onData(byte[] var1);
    }

    public static interface onCameraSetListener {
        public void onCameraSet(Camera var1);
    }
}

