/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.output;

import com.mm.mdlog.MDLog;

public class YuvToRGB {
    private static int R = 0;
    private static int G = 1;
    private static int B = 2;

    public static int[] I420ToRGB(byte[] src, int width, int height) {
        int n;
        int n2 = n = width * height;
        int n3 = n / 4 + n;
        int[] nArray = new int[n * 3];
        for (int i = 0; i < height; ++i) {
            int n4 = i * width;
            int n5 = i / 2 * (width / 2);
            int n6 = n2 + n5;
            int n7 = n3 + n5;
            for (int j = 0; j < width; ++j) {
                int n8 = n4 + j;
                int n9 = n6 + j / 2;
                int n10 = n7 + j / 2;
                int n11 = n8 * 3;
                MDLog.i((String)"yuv", (String)("y" + n8 + "u" + n9 + "V" + n10));
                RGB rGB = YuvToRGB.yuvTorgb(src[n8], src[n9], src[n10]);
                nArray[n11 + YuvToRGB.R] = rGB.r;
                nArray[n11 + YuvToRGB.G] = rGB.g;
                nArray[n11 + YuvToRGB.B] = rGB.b;
            }
        }
        return nArray;
    }

    private static RGB yuvTorgb(byte Y, byte U, byte V) {
        RGB rGB = new RGB();
        rGB.r = (int)((double)(Y & 0xFF) + 1.4075 * (double)((V & 0xFF) - 128));
        rGB.g = (int)((double)(Y & 0xFF) - 0.3455 * (double)((U & 0xFF) - 128) - 0.7169 * (double)((V & 0xFF) - 128));
        rGB.b = (int)((double)(Y & 0xFF) + 1.779 * (double)((U & 0xFF) - 128));
        int n = rGB.r < 0 ? 0 : (rGB.r = rGB.r > 255 ? 255 : rGB.r);
        int n2 = rGB.g < 0 ? 0 : (rGB.g = rGB.g > 255 ? 255 : rGB.g);
        rGB.b = rGB.b < 0 ? 0 : (rGB.b > 255 ? 255 : rGB.b);
        return rGB;
    }

    public static int[] YV16ToRGB(byte[] src, int width, int height) {
        int n;
        int n2 = n = width * height;
        int n3 = n / 2 + n;
        int[] nArray = new int[n * 3];
        for (int i = 0; i < height; ++i) {
            int n4 = i * width;
            int n5 = i * width / 2;
            int n6 = n2 + n5;
            int n7 = n3 + n5;
            for (int j = 0; j < width; ++j) {
                int n8 = n4 + j;
                int n9 = n6 + j / 2;
                int n10 = n7 + j / 2;
                int n11 = n8 * 3;
                RGB rGB = YuvToRGB.yuvTorgb(src[n8], src[n9], src[n10]);
                nArray[n11 + YuvToRGB.R] = rGB.r;
                nArray[n11 + YuvToRGB.G] = rGB.g;
                nArray[n11 + YuvToRGB.B] = rGB.b;
            }
        }
        return nArray;
    }

    public static int[] YV12ToRGB(byte[] src, int width, int height) {
        int n;
        int n2 = n = width * height;
        int n3 = n / 4 + n;
        int[] nArray = new int[n * 3];
        for (int i = 0; i < height; ++i) {
            int n4 = i * width;
            int n5 = i / 2 * (width / 2);
            int n6 = n2 + n5;
            int n7 = n3 + n5;
            for (int j = 0; j < width; ++j) {
                int n8 = n4 + j;
                int n9 = n6 + j / 2;
                int n10 = n7 + j / 2;
                int n11 = n8 * 3;
                RGB rGB = YuvToRGB.yuvTorgb(src[n8], src[n10], src[n9]);
                nArray[n11 + YuvToRGB.R] = rGB.r;
                nArray[n11 + YuvToRGB.G] = rGB.g;
                nArray[n11 + YuvToRGB.B] = rGB.b;
            }
        }
        return nArray;
    }

    public static int[] YUY2ToRGB(byte[] src, int width, int height) {
        int n = width * height;
        int[] nArray = new int[n * 3];
        int n2 = 2 * width;
        for (int i = 0; i < height; ++i) {
            int n3 = i * n2;
            for (int j = 0; j < n2; j += 4) {
                int n4 = j + n3;
                int n5 = n4 + 2;
                int n6 = n4 + 1;
                int n7 = n4 + 3;
                int n8 = (n4 >> 1) * 3;
                RGB rGB = YuvToRGB.yuvTorgb(src[n4], src[n6], src[n7]);
                nArray[n8 + YuvToRGB.R] = rGB.r;
                nArray[n8 + YuvToRGB.G] = rGB.g;
                nArray[n8 + YuvToRGB.B] = rGB.b;
                rGB = YuvToRGB.yuvTorgb(src[n5], src[n6], src[n7]);
                nArray[(n8 += 3) + YuvToRGB.R] = rGB.r;
                nArray[n8 + YuvToRGB.G] = rGB.g;
                nArray[n8 + YuvToRGB.B] = rGB.b;
            }
        }
        return nArray;
    }

    public static int[] UYVYToRGB(byte[] src, int width, int height) {
        int n = width * height;
        int[] nArray = new int[n * 3];
        int n2 = 2 * width;
        for (int i = 0; i < height; ++i) {
            int n3 = i * n2;
            for (int j = 0; j < n2; j += 4) {
                int n4 = j + n3;
                int n5 = n4 + 1;
                int n6 = n4 + 3;
                int n7 = n4 + 2;
                int n8 = (n4 >> 1) * 3;
                RGB rGB = YuvToRGB.yuvTorgb(src[n5], src[n4], src[n7]);
                nArray[n8 + YuvToRGB.R] = rGB.r;
                nArray[n8 + YuvToRGB.G] = rGB.g;
                nArray[n8 + YuvToRGB.B] = rGB.b;
                rGB = YuvToRGB.yuvTorgb(src[n6], src[n4], src[n7]);
                nArray[(n8 += 3) + YuvToRGB.R] = rGB.r;
                nArray[n8 + YuvToRGB.G] = rGB.g;
                nArray[n8 + YuvToRGB.B] = rGB.b;
            }
        }
        return nArray;
    }

    public static int[] NV21ToRGB(byte[] src, int width, int height) {
        int n;
        int n2 = n = width * height;
        int[] nArray = new int[n * 3];
        for (int i = 0; i < height; ++i) {
            int n3 = i * width;
            int n4 = i / 2 * width;
            int n5 = n2 + n4;
            for (int j = 0; j < width; ++j) {
                int n6 = n3 + j;
                int n7 = n5 + j / 2;
                int n8 = n7 + 1;
                int n9 = n6 * 3;
                RGB rGB = YuvToRGB.yuvTorgb(src[n6], src[n8], src[n7]);
                nArray[n9 + YuvToRGB.R] = rGB.r;
                nArray[n9 + YuvToRGB.G] = rGB.g;
                nArray[n9 + YuvToRGB.B] = rGB.b;
            }
        }
        return nArray;
    }

    public static int[] NV12ToRGB(byte[] src, int width, int height) {
        int n;
        int n2 = n = width * height;
        int[] nArray = new int[n * 3];
        for (int i = 0; i < height; ++i) {
            int n3 = i * width;
            int n4 = i / 2 * width;
            int n5 = n2 + n4;
            for (int j = 0; j < width; ++j) {
                int n6 = n3 + j;
                int n7 = n5 + j / 2;
                int n8 = n7 + 1;
                int n9 = n6 * 3;
                RGB rGB = YuvToRGB.yuvTorgb(src[n6], src[n7], src[n8]);
                nArray[n9 + YuvToRGB.R] = rGB.r;
                nArray[n9 + YuvToRGB.G] = rGB.g;
                nArray[n9 + YuvToRGB.B] = rGB.b;
            }
        }
        return nArray;
    }

    public static int[] NV16ToRGB(byte[] src, int width, int height) {
        int n;
        int n2 = n = width * height;
        int[] nArray = new int[n * 3];
        for (int i = 0; i < height; ++i) {
            int n3 = i * width;
            int n4 = i * width;
            int n5 = n2 + n4;
            for (int j = 0; j < width; ++j) {
                int n6 = n3 + j;
                int n7 = n5 + j / 2;
                int n8 = n7 + 1;
                int n9 = n6 * 3;
                RGB rGB = YuvToRGB.yuvTorgb(src[n6], src[n7], src[n8]);
                nArray[n9 + YuvToRGB.R] = rGB.r;
                nArray[n9 + YuvToRGB.G] = rGB.g;
                nArray[n9 + YuvToRGB.B] = rGB.b;
            }
        }
        return nArray;
    }

    public static int[] NV61ToRGB(byte[] src, int width, int height) {
        int n;
        int n2 = n = width * height;
        int[] nArray = new int[n * 3];
        for (int i = 0; i < height; ++i) {
            int n3 = i * width;
            int n4 = i * width;
            int n5 = n2 + n4;
            for (int j = 0; j < width; ++j) {
                int n6 = n3 + j;
                int n7 = n5 + j / 2;
                int n8 = n7 + 1;
                int n9 = n6 * 3;
                RGB rGB = YuvToRGB.yuvTorgb(src[n6], src[n8], src[n7]);
                nArray[n9 + YuvToRGB.R] = rGB.r;
                nArray[n9 + YuvToRGB.G] = rGB.g;
                nArray[n9 + YuvToRGB.B] = rGB.b;
            }
        }
        return nArray;
    }

    public static int[] YVYUToRGB(byte[] src, int width, int height) {
        int n = width * height;
        int[] nArray = new int[n * 3];
        int n2 = 2 * width;
        for (int i = 0; i < height; ++i) {
            int n3 = i * n2;
            for (int j = 0; j < n2; j += 4) {
                int n4 = j + n3;
                int n5 = n4 + 2;
                int n6 = n4 + 1;
                int n7 = n4 + 3;
                int n8 = (n4 >> 1) * 3;
                RGB rGB = YuvToRGB.yuvTorgb(src[n4], src[n7], src[n6]);
                nArray[n8 + YuvToRGB.R] = rGB.r;
                nArray[n8 + YuvToRGB.G] = rGB.g;
                nArray[n8 + YuvToRGB.B] = rGB.b;
                rGB = YuvToRGB.yuvTorgb(src[n5], src[n7], src[n6]);
                nArray[(n8 += 3) + YuvToRGB.R] = rGB.r;
                nArray[n8 + YuvToRGB.G] = rGB.g;
                nArray[n8 + YuvToRGB.B] = rGB.b;
            }
        }
        return nArray;
    }

    public static int[] VYUYToRGB(byte[] src, int width, int height) {
        int n = width * height;
        int[] nArray = new int[n * 3];
        int n2 = 2 * width;
        for (int i = 0; i < height; ++i) {
            int n3 = i * n2;
            for (int j = 0; j < n2; j += 4) {
                int n4 = j + n3;
                int n5 = n4 + 1;
                int n6 = n4 + 3;
                int n7 = n4 + 2;
                int n8 = (n7 >> 1) * 3;
                RGB rGB = YuvToRGB.yuvTorgb(src[n5], src[n7], src[n4]);
                nArray[n8 + YuvToRGB.R] = rGB.r;
                nArray[n8 + YuvToRGB.G] = rGB.g;
                nArray[n8 + YuvToRGB.B] = rGB.b;
                rGB = YuvToRGB.yuvTorgb(src[n6], src[n7], src[n4]);
                nArray[(n8 += 3) + YuvToRGB.R] = rGB.r;
                nArray[n8 + YuvToRGB.G] = rGB.g;
                nArray[n8 + YuvToRGB.B] = rGB.b;
            }
        }
        return nArray;
    }

    private static class RGB {
        public int r;
        public int g;
        public int b;

        private RGB() {
        }
    }
}

