/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.output;

import android.opengl.GLES20;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import project.android.imageprocessing.GLRenderer;
import project.android.imageprocessing.RendererCommon;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.output.GLTextureInputRenderer;

public class YUVFileEndpoint
extends GLRenderer
implements GLTextureInputRenderer {
    private static final String TAG = "YUVFileEndpoint";
    private static final String UNIFORM_UNIT_VALUE = "xUnit";
    private static final String UNIFORM_TEX_MATRIX = "texMatrix";
    private static final String UNIFORM_TEX_COEFFS = "coeffs";
    private static final String UNIFORM_DRAW_TYPE = "drawType";
    private static final String VERTEX_SHADER = "attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \n varying vec2 textureCoordinate;\n \nuniform mat4 texMatrix;\n\nvoid main()\n{\n    gl_Position = position;\n  textureCoordinate = (texMatrix * inputTextureCoordinate).xy;\n}\n";
    private static final String FRAGMENT_SHADER = "precision highp float;\nvarying highp vec2 textureCoordinate;\nuniform sampler2D inputImageTexture;\nuniform vec2 xUnit;\nuniform vec4 coeffs;\nvec2 newCoord;\n uniform float drawType; \nvoid main() {\n  newCoord = vec2(textureCoordinate.x,textureCoordinate.y);  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      texture2D(inputImageTexture, newCoord - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      texture2D(inputImageTexture, newCoord - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      texture2D(inputImageTexture, newCoord + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      texture2D(inputImageTexture, newCoord + 1.5 * xUnit).rgb);\n}\n";
    public YUVDateOutputListener yuvDateOutputListener;
    protected int[] frameBuffer;
    protected int[] texture_out;
    protected int[] depthRenderBuffer;
    BufferedOutputStream fops;
    int realWidth;
    int realHeight;
    int mWidth;
    int mHeight;
    int y_width;
    int uv_width;
    int uv_height;
    int total_height;
    private String filePath;
    private boolean increment;
    private int curNumber;
    private boolean storeToMedia;
    private int texMatrixHandler;
    private int xUnitValueHandler;
    private int coeffsHandler;
    private int drawTypeHandler;

    public YUVFileEndpoint() {
        this.storeToMedia = this.storeToMedia;
        this.filePath = this.filePath;
        this.increment = this.increment;
        this.curNumber = 1;
        this.textureVertices = new FloatBuffer[4];
        float[] fArray = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        this.textureVertices[0] = ByteBuffer.allocateDirect(fArray.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[0].put(fArray).position(0);
        float[] fArray2 = new float[]{1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
        this.textureVertices[1] = ByteBuffer.allocateDirect(fArray2.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[1].put(fArray2).position(0);
        float[] fArray3 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
        this.textureVertices[2] = ByteBuffer.allocateDirect(fArray3.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[2].put(fArray3).position(0);
        float[] fArray4 = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
        this.textureVertices[3] = ByteBuffer.allocateDirect(fArray4.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[3].put(fArray4).position(0);
    }

    public static final float[] identityMatrix() {
        return new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.texMatrixHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TEX_MATRIX);
        this.xUnitValueHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_UNIT_VALUE);
        this.coeffsHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TEX_COEFFS);
        this.drawTypeHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_DRAW_TYPE);
    }

    private void createfile() {
        File file = new File(this.filePath + ".264");
        if (file.exists()) {
            file.delete();
        }
        try {
            this.fops = new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    protected String getFragmentShader() {
        return FRAGMENT_SHADER;
    }

    @Override
    protected String getVertexShader() {
        return VERTEX_SHADER;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.frameBuffer != null) {
            GLES20.glDeleteFramebuffers((int)1, (int[])this.frameBuffer, (int)0);
            this.frameBuffer = null;
        }
        if (this.texture_out != null) {
            GLES20.glDeleteTextures((int)1, (int[])this.texture_out, (int)0);
            this.texture_out = null;
        }
        if (this.depthRenderBuffer != null) {
            GLES20.glDeleteRenderbuffers((int)1, (int[])this.depthRenderBuffer, (int)0);
            this.depthRenderBuffer = null;
        }
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniformMatrix4fv((int)this.texMatrixHandler, (int)1, (boolean)false, (float[])YUVFileEndpoint.identityMatrix(), (int)0);
    }

    @Override
    public void drawFrame() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        long l = System.nanoTime();
        if (this.frameBuffer == null) {
            if (this.getWidth() != 0 && this.getHeight() != 0) {
                this.initFBO();
            } else {
                return;
            }
        }
        GLES20.glBindFramebuffer((int)36160, (int)this.frameBuffer[0]);
        GLES20.glUseProgram((int)this.programHandle);
        GLES20.glClear((int)16640);
        GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
        this.passShaderValues();
        float[] fArray = new float[16];
        fArray = RendererCommon.multiplyMatrices(YUVFileEndpoint.identityMatrix(), RendererCommon.verticalFlipMatrix());
        GLES20.glViewport((int)0, (int)0, (int)this.y_width, (int)n2);
        GLES20.glUniform2f((int)this.xUnitValueHandler, (float)(fArray[0] / (float)n), (float)(fArray[1] / (float)n));
        GLES20.glUniform4f((int)this.coeffsHandler, (float)0.299f, (float)0.587f, (float)0.114f, (float)0.0f);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glViewport((int)0, (int)n2, (int)this.uv_width, (int)this.uv_height);
        GLES20.glUniform2f((int)this.xUnitValueHandler, (float)(2.0f * fArray[0] / (float)n), (float)(2.0f * fArray[1] / (float)n));
        GLES20.glUniform4f((int)this.coeffsHandler, (float)-0.169f, (float)-0.331f, (float)0.499f, (float)0.5f);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glViewport((int)(this.y_width / 2), (int)n2, (int)this.uv_width, (int)this.uv_height);
        GLES20.glUniform4f((int)this.coeffsHandler, (float)0.499f, (float)-0.418f, (float)-0.0813f, (float)0.5f);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glBindTexture((int)3553, (int)0);
        long l2 = System.nanoTime();
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.realWidth * this.realHeight * 4);
        GLES20.glReadPixels((int)0, (int)0, (int)this.realWidth, (int)this.realHeight, (int)6408, (int)5121, (Buffer)byteBuffer);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        if (null != this.yuvDateOutputListener) {
            this.yuvDateOutputListener.outputData(byteBuffer, l);
        }
    }

    @Override
    protected void handleSizeChange() {
        this.mWidth = this.getWidth();
        this.mHeight = this.getHeight();
        this.y_width = (this.mWidth + 3) / 4;
        this.uv_width = (this.mWidth + 7) / 8;
        this.uv_height = (this.mHeight + 1) / 2;
        this.total_height = this.mHeight + this.uv_height;
        this.realWidth = this.y_width;
        this.realHeight = this.total_height;
        this.initFBO();
    }

    private void initFBO() {
        if (this.frameBuffer != null) {
            GLES20.glDeleteFramebuffers((int)1, (int[])this.frameBuffer, (int)0);
            this.frameBuffer = null;
        }
        if (this.texture_out != null) {
            GLES20.glDeleteTextures((int)1, (int[])this.texture_out, (int)0);
            this.texture_out = null;
        }
        if (this.depthRenderBuffer != null) {
            GLES20.glDeleteRenderbuffers((int)1, (int[])this.depthRenderBuffer, (int)0);
            this.depthRenderBuffer = null;
        }
        this.frameBuffer = new int[1];
        this.texture_out = new int[1];
        this.depthRenderBuffer = new int[1];
        GLES20.glGenFramebuffers((int)1, (int[])this.frameBuffer, (int)0);
        GLES20.glGenRenderbuffers((int)1, (int[])this.depthRenderBuffer, (int)0);
        GLES20.glGenTextures((int)1, (int[])this.texture_out, (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)this.frameBuffer[0]);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.texture_out[0]);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)(this.getWidth() / 4), (int)(this.getHeight() + this.getHeight() / 2), (int)0, (int)6408, (int)5121, null);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.texture_out[0], (int)0);
        GLES20.glBindRenderbuffer((int)36161, (int)this.depthRenderBuffer[0]);
        GLES20.glRenderbufferStorage((int)36161, (int)33189, (int)(this.getWidth() / 4), (int)(this.getHeight() + this.getHeight() / 2));
        GLES20.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)this.depthRenderBuffer[0]);
        int n = GLES20.glCheckFramebufferStatus((int)36160);
        if (n != 36053) {
            throw new RuntimeException(this + ": Failed to set up render buffer with status " + n + " and error " + GLES20.glGetError());
        }
    }

    @Override
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        this.texture_in = texture;
        this.setWidth(this.getWidth());
        this.setHeight(this.getHeight());
        this.onDrawFrame();
        source.unlockRenderBuffer();
    }

    public static interface YUVDateOutputListener {
        public void outputData(ByteBuffer var1, long var2);
    }
}

