/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.output;

import android.opengl.GLES20;
import project.android.imageprocessing.FastImageProcessingPipeline;
import project.android.imageprocessing.GLRenderer;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.output.GLTextureInputRenderer;

public class ScreenCameraEndpoint
extends GLRenderer
implements GLTextureInputRenderer {
    private FastImageProcessingPipeline rendererContext;
    private float inputScale;

    public ScreenCameraEndpoint(FastImageProcessingPipeline rendererContext) {
        this.rendererContext = rendererContext;
        this.inputScale = 0.75f;
    }

    @Override
    protected void initWithGLContext() {
        this.setRenderSize(this.rendererContext.getWidth(), this.rendererContext.getHeight());
        super.initWithGLContext();
    }

    public float getInputScale() {
        return this.inputScale;
    }

    public void setInputScale(float inputScale) {
        this.inputScale = inputScale;
    }

    @Override
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        this.texture_in = texture;
        this.setWidth(source.getWidth());
        this.setHeight(source.getHeight());
        this.onDrawFrame();
    }

    @Override
    protected void drawFrame() {
        if (this.texture_in == 0) {
            return;
        }
        GLES20.glViewport((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
        GLES20.glUseProgram((int)this.programHandle);
        GLES20.glClear((int)16640);
        GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
        this.passShaderValues();
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
    }
}

