/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.output;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.provider.MediaStore;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import project.android.imageprocessing.GLRenderer;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.output.GLTextureInputRenderer;

public class JPGFileEndpoint
extends GLRenderer
implements GLTextureInputRenderer {
    protected int[] frameBuffer;
    protected int[] texture_out;
    protected int[] depthRenderBuffer;
    private String filePath;
    private boolean increment;
    private int curNumber;
    private Context context;
    private boolean storeToMedia;

    public JPGFileEndpoint(Context context, boolean storeToMedia, String filePath, boolean increment) {
        this.context = context;
        this.storeToMedia = storeToMedia;
        this.filePath = filePath;
        this.increment = increment;
        this.curNumber = 1;
        this.textureVertices = new FloatBuffer[4];
        float[] fArray = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        this.textureVertices[0] = ByteBuffer.allocateDirect(fArray.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[0].put(fArray).position(0);
        float[] fArray2 = new float[]{1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
        this.textureVertices[1] = ByteBuffer.allocateDirect(fArray2.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[1].put(fArray2).position(0);
        float[] fArray3 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
        this.textureVertices[2] = ByteBuffer.allocateDirect(fArray3.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[2].put(fArray3).position(0);
        float[] fArray4 = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
        this.textureVertices[3] = ByteBuffer.allocateDirect(fArray4.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[3].put(fArray4).position(0);
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.frameBuffer != null) {
            GLES20.glDeleteFramebuffers((int)1, (int[])this.frameBuffer, (int)0);
            this.frameBuffer = null;
        }
        if (this.texture_out != null) {
            GLES20.glDeleteTextures((int)1, (int[])this.texture_out, (int)0);
            this.texture_out = null;
        }
        if (this.depthRenderBuffer != null) {
            GLES20.glDeleteRenderbuffers((int)1, (int[])this.depthRenderBuffer, (int)0);
            this.depthRenderBuffer = null;
        }
    }

    @Override
    public void drawFrame() {
        String string;
        if (this.frameBuffer == null) {
            if (this.getWidth() != 0 && this.getHeight() != 0) {
                this.initFBO();
            } else {
                return;
            }
        }
        GLES20.glBindFramebuffer((int)36160, (int)this.frameBuffer[0]);
        GLES20.glViewport((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
        int n = 0;
        int n2 = 0;
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        GLES20.glUseProgram((int)this.programHandle);
        GLES20.glClear((int)16640);
        GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
        this.passShaderValues();
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        int[] nArray = new int[this.getWidth() * this.getHeight()];
        IntBuffer intBuffer = IntBuffer.wrap(nArray);
        intBuffer.position(0);
        GLES20.glReadPixels((int)n, (int)n2, (int)n3, (int)n4, (int)6408, (int)5121, (Buffer)intBuffer);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = nArray[i] & 0xFF00FF00 | nArray[i] >> 16 & 0xFF | nArray[i] << 16 & 0xFF0000;
        }
        Bitmap bitmap = Bitmap.createBitmap((int[])nArray, (int)n3, (int)n4, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (this.increment) {
            string = this.filePath + this.curNumber + ".jpg";
            ++this.curNumber;
        } else {
            string = this.filePath + ".jpg";
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fileOutputStream);
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
            if (this.storeToMedia) {
                String[] stringArray = this.filePath.split("/");
                MediaStore.Images.Media.insertImage((ContentResolver)this.context.getContentResolver(), (String)string, (String)stringArray[stringArray.length - 1], (String)"");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    protected void handleSizeChange() {
        this.initFBO();
    }

    private void initFBO() {
        if (this.frameBuffer != null) {
            GLES20.glDeleteFramebuffers((int)1, (int[])this.frameBuffer, (int)0);
            this.frameBuffer = null;
        }
        if (this.texture_out != null) {
            GLES20.glDeleteTextures((int)1, (int[])this.texture_out, (int)0);
            this.texture_out = null;
        }
        if (this.depthRenderBuffer != null) {
            GLES20.glDeleteRenderbuffers((int)1, (int[])this.depthRenderBuffer, (int)0);
            this.depthRenderBuffer = null;
        }
        this.frameBuffer = new int[1];
        this.texture_out = new int[1];
        this.depthRenderBuffer = new int[1];
        GLES20.glGenFramebuffers((int)1, (int[])this.frameBuffer, (int)0);
        GLES20.glGenRenderbuffers((int)1, (int[])this.depthRenderBuffer, (int)0);
        GLES20.glGenTextures((int)1, (int[])this.texture_out, (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)this.frameBuffer[0]);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.texture_out[0]);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.getWidth(), (int)this.getHeight(), (int)0, (int)6408, (int)5121, null);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.texture_out[0], (int)0);
        GLES20.glBindRenderbuffer((int)36161, (int)this.depthRenderBuffer[0]);
        GLES20.glRenderbufferStorage((int)36161, (int)33189, (int)this.getWidth(), (int)this.getHeight());
        GLES20.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)this.depthRenderBuffer[0]);
        int n = GLES20.glCheckFramebufferStatus((int)36160);
        if (n != 36053) {
            throw new RuntimeException(this + ": Failed to set up render buffer with status " + n + " and error " + GLES20.glGetError());
        }
    }

    @Override
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        this.texture_in = texture;
        this.setWidth(source.getWidth());
        this.setHeight(source.getHeight());
        this.onDrawFrame();
    }
}

