/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.input;

import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class TextureResourceInput
extends GLTextureOutputRenderer
implements SurfaceTexture.OnFrameAvailableListener {
    private static final String UNIFORM_CAM_MATRIX = "u_Matrix";
    public SurfaceTexture videoTex;
    private int matrixHandle;
    private float[] matrix = new float[16];
    private boolean mSizeChanged = false;

    public TextureResourceInput(int width, int height) {
        this.setRenderSize(width, height);
        this.textureVertices = new FloatBuffer[4];
        float[] fArray = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        this.textureVertices[0] = ByteBuffer.allocateDirect(fArray.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[0].put(fArray).position(0);
        float[] fArray2 = new float[]{1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
        this.textureVertices[1] = ByteBuffer.allocateDirect(fArray2.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[1].put(fArray2).position(0);
        float[] fArray3 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
        this.textureVertices[2] = ByteBuffer.allocateDirect(fArray3.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[2].put(fArray3).position(0);
        float[] fArray4 = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
        this.textureVertices[3] = ByteBuffer.allocateDirect(fArray4.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[3].put(fArray4).position(0);
        this.markAsDirty();
    }

    public void changeCurRotation(int rotation) {
        this.curRotation = 0;
        this.rotateClockwise90Degrees(rotation / 90);
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.texture_in != 0) {
            int[] nArray = new int[]{this.texture_in};
            GLES20.glDeleteTextures((int)1, (int[])nArray, (int)0);
        }
    }

    private void bindTexture() {
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)this.texture_in);
    }

    @Override
    protected void passShaderValues() {
        this.renderVertices.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.renderVertices);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        this.textureVertices[this.curRotation].position(0);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.textureVertices[this.curRotation]);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        this.bindTexture();
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
        this.videoTex.getTransformMatrix(this.matrix);
        GLES20.glUniformMatrix4fv((int)this.matrixHandle, (int)1, (boolean)false, (float[])this.matrix, (int)0);
    }

    public SurfaceTexture getVideoTexture() {
        if (null == this.videoTex) {
            int[] nArray = new int[1];
            GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
            GLES20.glBindTexture((int)36197, (int)nArray[0]);
            GLES20.glTexParameterf((int)36197, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
            GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
            GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
            this.texture_in = nArray[0];
            this.videoTex = new SurfaceTexture(this.texture_in);
            this.videoTex.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        }
        return this.videoTex;
    }

    @Override
    protected String getFragmentShader() {
        return "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES inputImageTexture0;\nvarying vec2 textureCoordinate;\nvoid main() {\n   gl_FragColor = texture2D(inputImageTexture0, textureCoordinate);\n}\n";
    }

    @Override
    protected String getVertexShader() {
        return "uniform mat4 u_Matrix;\nattribute vec4 position;\nattribute vec2 inputTextureCoordinate;\nvarying vec2 textureCoordinate;\nvoid main() {\n   vec4 texPos = u_Matrix * vec4(inputTextureCoordinate, 1, 1);\n   textureCoordinate = texPos.xy;\n   gl_Position = position;\n}\n";
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
    }
}

