/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.input;

import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class NV21PreviewInput
extends GLTextureOutputRenderer {
    public static final int FLIP_VERTICAL = 0;
    public static final int FLIP_HORIZONTAL = 1;
    public static final int FLIP_BOTH = 2;
    public static final int FLIP_NONE = 3;
    private static final String UNIFORM_CAM_MATRIX = "u_Matrix";
    private static final String vertexShaderCode = "attribute vec4 position;attribute mediump vec4 inputTextureCoordinate;varying mediump vec2 coordinate;void main(){    gl_Position = position;    coordinate = inputTextureCoordinate.xy;}";
    private static final String fragmentShaderCode = "precision mediump float;uniform sampler2D SamplerY;uniform sampler2D SamplerUV;varying mediump vec2 coordinate;void main(){   float r, g, b, y, u, v;\n   y = texture2D(SamplerY, coordinate).r;\n   u = texture2D(SamplerUV, coordinate).a - 0.5;\n   v = texture2D(SamplerUV, coordinate).r - 0.5;\n   r = y + 1.13983*v;\n   g = y - 0.39465*u - 0.58060*v;\n   b = y + 2.03211*u;\n   gl_FragColor = vec4(r, g, b, 1.0);\n}";
    public ByteBuffer mYByteBuffer = null;
    public ByteBuffer mUVByteBufer = null;
    private int[] textures;

    public NV21PreviewInput() {
        this.useNewViewPort = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateYUVBuffer(ByteBuffer yByteBuffer, ByteBuffer uvByteBufer) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.mYByteBuffer = yByteBuffer;
            this.mUVByteBufer = uvByteBufer;
        }
    }

    public void changeCurRotation(int rotation) {
        this.curRotation = 0;
        this.rotateClockwise90Degrees(rotation / 90);
    }

    public void flipPosition(int flipDirection) {
        if (flipDirection == 3) {
            this.setRenderVertices(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
            this.textureVertices = new FloatBuffer[4];
            float[] fArray = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
            this.textureVertices[0] = ByteBuffer.allocateDirect(fArray.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.textureVertices[0].put(fArray).position(0);
            float[] fArray2 = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f};
            this.textureVertices[1] = ByteBuffer.allocateDirect(fArray2.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.textureVertices[1].put(fArray2).position(0);
            float[] fArray3 = new float[]{1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f};
            this.textureVertices[2] = ByteBuffer.allocateDirect(fArray3.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.textureVertices[2].put(fArray3).position(0);
            float[] fArray4 = new float[]{1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
            this.textureVertices[3] = ByteBuffer.allocateDirect(fArray4.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.textureVertices[3].put(fArray4).position(0);
            return;
        }
        float f = 0.0f;
        float f2 = 1.0f;
        float f3 = 0.0f;
        float f4 = 1.0f;
        switch (flipDirection) {
            case 0: {
                f = 1.0f;
                f2 = 0.0f;
                break;
            }
            case 1: {
                f3 = 1.0f;
                f4 = 0.0f;
                break;
            }
            case 2: {
                f = 1.0f;
                f2 = 0.0f;
                f3 = 1.0f;
                f4 = 0.0f;
            }
        }
        float[] fArray = new float[]{f, f3, f2, f3, f, f4, f2, f4};
        this.textureVertices[0] = ByteBuffer.allocateDirect(fArray.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[0].put(fArray).position(0);
        float[] fArray5 = new float[]{f3, f2, f3, f, f4, f2, f4, f};
        this.textureVertices[1] = ByteBuffer.allocateDirect(fArray5.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[1].put(fArray5).position(0);
        float[] fArray6 = new float[]{f2, f4, f, f4, f2, f3, f, f3};
        this.textureVertices[2] = ByteBuffer.allocateDirect(fArray6.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[2].put(fArray6).position(0);
        float[] fArray7 = new float[]{f4, f, f4, f2, f3, f, f3, f2};
        this.textureVertices[3] = ByteBuffer.allocateDirect(fArray7.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[3].put(fArray7).position(0);
        for (int i = 0; i < 4; ++i) {
        }
    }

    @Override
    protected void initWithGLContext() {
        super.initWithGLContext();
        this.textures = new int[2];
        GLES20.glGenTextures((int)2, (int[])this.textures, (int)0);
        for (int i = 0; i < 2; ++i) {
            int n = this.textures[i];
            GLES20.glActiveTexture((int)(33984 + i));
            GLES20.glBindTexture((int)3553, (int)n);
            GLES20.glPixelStorei((int)3317, (int)1);
            GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
            GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
            GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
            GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        }
        GLES20.glUseProgram((int)this.programHandle);
        GLES20.glUniform1i((int)GLES20.glGetUniformLocation((int)this.programHandle, (String)"SamplerY"), (int)0);
        GLES20.glUniform1i((int)GLES20.glGetUniformLocation((int)this.programHandle, (String)"SamplerUV"), (int)1);
    }

    @Override
    public void destroy() {
        super.destroy();
        try {
            if (this.texture_in != 0) {
                int[] nArray = new int[]{this.texture_in};
                GLES20.glDeleteTextures((int)1, (int[])nArray, (int)0);
                this.texture_in = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            GLES20.glDeleteTextures((int)1, (int[])this.textures, (int)0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onDrawFrame() {
        this.markAsDirty();
        super.onDrawFrame();
    }

    @Override
    protected String getFragmentShader() {
        return fragmentShaderCode;
    }

    @Override
    protected String getVertexShader() {
        return vertexShaderCode;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
    }

    public void onPause() {
    }

    public void onResume() {
        this.reInitialize();
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        this.renderVertices.position(0);
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.curRotation % 2 == 1) {
            n = this.getHeight();
            n2 = this.getWidth();
        }
        GLES20.glUseProgram((int)this.programHandle);
        GLES20.glUniform1i((int)GLES20.glGetUniformLocation((int)this.programHandle, (String)"SamplerY"), (int)0);
        GLES20.glUniform1i((int)GLES20.glGetUniformLocation((int)this.programHandle, (String)"SamplerUV"), (int)1);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.renderVertices);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        this.textureVertices[this.curRotation].position(0);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.textureVertices[this.curRotation]);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        ByteBuffer byteBuffer = this.mYByteBuffer;
        ByteBuffer byteBuffer2 = this.mUVByteBufer;
        if (byteBuffer == null || byteBuffer2 == null) {
            return;
        }
        byteBuffer.position(0);
        byteBuffer2.position(0);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.textures[0]);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)n, (int)n2, (int)0, (int)6409, (int)5121, (Buffer)byteBuffer);
        GLES20.glActiveTexture((int)33985);
        GLES20.glBindTexture((int)3553, (int)this.textures[1]);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6410, (int)(n / 2), (int)(n2 / 2), (int)0, (int)6410, (int)5121, (Buffer)byteBuffer2);
        GLES20.glClear((int)16384);
    }
}

