/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.input;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import project.android.imageprocessing.helper.ImageHelper;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class ImageResourceInput
extends GLTextureOutputRenderer {
    private Context context;
    private GLSurfaceView view;
    private Bitmap bitmap;
    private int imageWidth;
    private int imageHeight;
    private boolean newBitmap;

    public ImageResourceInput(GLSurfaceView view, Bitmap bitmap) {
        this.view = view;
        this.setImage(bitmap);
    }

    public ImageResourceInput(GLSurfaceView view, Context context, int resourceId) {
        this.context = context;
        this.view = view;
        this.setImage(resourceId);
    }

    public ImageResourceInput(GLSurfaceView view, String pathName) {
        this.view = view;
        this.setImage(pathName);
    }

    @Override
    protected void drawFrame() {
        if (this.newBitmap) {
            this.loadTexture();
        }
        super.drawFrame();
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    private void loadImage(Bitmap bitmap) {
        this.bitmap = bitmap;
        this.imageWidth = bitmap.getWidth();
        this.imageHeight = bitmap.getHeight();
        this.setRenderSize(this.imageWidth, this.imageHeight);
        this.newBitmap = true;
        this.textureVertices = new FloatBuffer[4];
        float[] fArray = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        this.textureVertices[0] = ByteBuffer.allocateDirect(fArray.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[0].put(fArray).position(0);
        float[] fArray2 = new float[]{1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
        this.textureVertices[1] = ByteBuffer.allocateDirect(fArray2.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[1].put(fArray2).position(0);
        float[] fArray3 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
        this.textureVertices[2] = ByteBuffer.allocateDirect(fArray3.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[2].put(fArray3).position(0);
        float[] fArray4 = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
        this.textureVertices[3] = ByteBuffer.allocateDirect(fArray4.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[3].put(fArray4).position(0);
        this.view.requestRender();
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.texture_in != 0) {
            int[] nArray = new int[]{this.texture_in};
            GLES20.glDeleteTextures((int)1, (int[])nArray, (int)0);
        }
        if (this.bitmap != null && !this.bitmap.isRecycled()) {
            this.bitmap.recycle();
            this.bitmap = null;
        }
        this.newBitmap = true;
    }

    private void loadTexture() {
        if (this.texture_in != 0) {
            int[] nArray = new int[]{this.texture_in};
            GLES20.glDeleteTextures((int)1, (int[])nArray, (int)0);
        }
        this.texture_in = ImageHelper.bitmapToTexture(this.bitmap);
        this.newBitmap = false;
        this.markAsDirty();
    }

    @Override
    public void releaseFrameBuffer() {
        super.releaseFrameBuffer();
        super.destroy();
        if (this.texture_in != 0) {
            int[] nArray = new int[]{this.texture_in};
            GLES20.glDeleteTextures((int)1, (int[])nArray, (int)0);
        }
    }

    public void setImage(Bitmap bitmap) {
        this.loadImage(bitmap);
    }

    public void setImage(int resourceId) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inScaled = false;
        this.loadImage(BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)resourceId, (BitmapFactory.Options)options));
    }

    public void setImage(String filePath) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inScaled = false;
        this.loadImage(BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options));
    }
}

