/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.input;

import android.opengl.GLES20;
import java.util.ArrayList;
import java.util.List;
import project.android.imageprocessing.GLFrameBuffer;
import project.android.imageprocessing.GLRenderer;
import project.android.imageprocessing.output.GLTextureInputRenderer;

public abstract class GLTextureOutputRenderer
extends GLRenderer {
    protected GLFrameBuffer glFrameBuffer;
    protected List<GLTextureInputRenderer> targets;
    protected Object listLock = new Object();
    protected boolean dirty;
    private String filterKey;
    private boolean isFloatTexture = false;

    public GLTextureOutputRenderer() {
        this.targets = new ArrayList<GLTextureInputRenderer>();
        this.filterKey = this.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addTarget(GLTextureInputRenderer target) {
        Object object = this.listLock;
        synchronized (object) {
            if (this.targets != null && this.targets.contains(target)) {
                return;
            }
            this.targets.add(target);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (null != this.glFrameBuffer) {
            this.glFrameBuffer.destoryBuffer();
            this.glFrameBuffer = null;
        }
    }

    @Override
    public void releaseFrameBuffer() {
        super.releaseFrameBuffer();
        if (null != this.glFrameBuffer) {
            this.glFrameBuffer.destoryBuffer();
            this.glFrameBuffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void drawFrame() {
        long l = System.currentTimeMillis();
        if (this.glFrameBuffer == null) {
            if (this.getWidth() != 0 && this.getHeight() != 0) {
                this.initFBO();
            } else {
                return;
            }
        }
        boolean bl = false;
        if (this.glFrameBuffer != null && this.glFrameBuffer.getFrameBuffer() == null) {
            if (this.getWidth() != 0 && this.getHeight() != 0) {
                this.initFBO();
            } else {
                return;
            }
        }
        if (this.dirty) {
            bl = true;
            GLES20.glBindFramebuffer((int)36160, (int)this.glFrameBuffer.getFrameBuffer()[0]);
            GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
            GLES20.glClear((int)16640);
            this.drawSub();
            GLES20.glBindFramebuffer((int)36160, (int)0);
        }
        long l2 = System.currentTimeMillis();
        Object object = this.listLock;
        synchronized (object) {
            for (GLTextureInputRenderer gLTextureInputRenderer : this.targets) {
                if (gLTextureInputRenderer == null || this.glFrameBuffer == null) continue;
                gLTextureInputRenderer.newTextureReady(this.glFrameBuffer.getTexture_out()[0], this, bl);
            }
        }
    }

    public void drawSub() {
        this.drawIndeed();
    }

    private void drawIndeed() {
        super.drawFrame();
    }

    public Object getLockObject() {
        return this.listLock;
    }

    public List<GLTextureInputRenderer> getTargets() {
        return this.targets;
    }

    @Override
    protected void handleSizeChange() {
        this.initFBO();
    }

    public void setFloatTexture(boolean floatTexture) {
        this.isFloatTexture = floatTexture;
    }

    protected void initFBO() {
        if (null != this.glFrameBuffer) {
            this.glFrameBuffer.destoryBuffer();
        }
        this.glFrameBuffer = new GLFrameBuffer(this.getWidth(), this.getHeight());
        this.glFrameBuffer.setFloat(this.isFloatTexture);
        this.glFrameBuffer.activityFrameBuffer(this.getWidth(), this.getHeight());
        int n = GLES20.glCheckFramebufferStatus((int)36160);
        if (n != 36053) {
            if (this.isFloatTexture) {
                if (null != this.glFrameBuffer) {
                    this.glFrameBuffer.destoryBuffer();
                }
                this.glFrameBuffer = new GLFrameBuffer(this.getWidth(), this.getHeight());
                this.isFloatTexture = false;
                this.glFrameBuffer.setFloat(false);
                this.glFrameBuffer.activityFrameBuffer(this.getWidth(), this.getHeight());
                n = GLES20.glCheckFramebufferStatus((int)36160);
                if (n != 36053) {
                    throw new RuntimeException(this + ": Failed to set up render buffer with status " + n + " and error " + GLES20.glGetError());
                }
            } else {
                throw new RuntimeException(this + ": Failed to set up render buffer with status " + n + " and error " + GLES20.glGetError());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTarget(GLTextureInputRenderer target) {
        Object object = this.listLock;
        synchronized (object) {
            this.targets.remove(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTarget() {
        Object object = this.listLock;
        synchronized (object) {
            this.targets.clear();
            if (null != this.glFrameBuffer) {
                this.glFrameBuffer.destoryBuffer();
                this.glFrameBuffer = null;
            }
        }
    }

    public void markAsDirty() {
        this.dirty = true;
    }

    public void unlockRenderBuffer() {
        if (null != this.glFrameBuffer) {
            this.glFrameBuffer.unlock();
        }
    }

    public void lockRenderBuffer() {
        if (null != this.glFrameBuffer) {
            this.glFrameBuffer.lock();
        }
    }

    public int getTextOutID() {
        if (this.glFrameBuffer != null) {
            return this.glFrameBuffer.getTexture_out()[0];
        }
        return 0;
    }

    public String getFilterKey() {
        return this.filterKey;
    }

    public void setFilterKey(String filterKey) {
        this.filterKey = filterKey;
    }
}

