/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.helper;

import android.opengl.GLES20;
import com.mm.mdlog.MDLog;

public class ShaderHelper {
    private static final String TAG = "mediaRender";

    public static int buildProgram(String vertexSourceCode, String fragmentSourceCode) {
        int n = ShaderHelper.compileVertexShader(vertexSourceCode);
        int n2 = ShaderHelper.compileFragmentShader(fragmentSourceCode);
        int n3 = ShaderHelper.linkProgram(n, n2);
        ShaderHelper.validateProgram(n3);
        return n3;
    }

    private static void validateProgram(int program) {
        GLES20.glValidateProgram((int)program);
        int[] nArray = new int[1];
        GLES20.glGetProgramiv((int)program, (int)35715, (int[])nArray, (int)0);
        if (nArray[0] == 0) {
            MDLog.e((String)TAG, (String)("Results of validating program : " + nArray[0] + "\n Log : " + GLES20.glGetProgramInfoLog((int)program)));
        }
    }

    private static int linkProgram(int vertexShader, int fragmentShader) {
        int n = GLES20.glCreateProgram();
        GLES20.glAttachShader((int)n, (int)vertexShader);
        GLES20.glAttachShader((int)n, (int)fragmentShader);
        GLES20.glLinkProgram((int)n);
        int[] nArray = new int[1];
        GLES20.glGetProgramiv((int)n, (int)35714, (int[])nArray, (int)0);
        if (nArray[0] == 0) {
            GLES20.glDeleteProgram((int)n);
            MDLog.e((String)TAG, (String)("Linking of program failed. Reason : \n" + GLES20.glGetProgramInfoLog((int)n)));
        }
        return n;
    }

    private static int compileVertexShader(String shaderCode) {
        return ShaderHelper.compileShader(35633, shaderCode);
    }

    private static int compileFragmentShader(String shaderCode) {
        return ShaderHelper.compileShader(35632, shaderCode);
    }

    private static int compileShader(int type, String shaderSourceCode) {
        int n = GLES20.glCreateShader((int)type);
        String string = "none";
        if (n != 0) {
            GLES20.glShaderSource((int)n, (String)shaderSourceCode);
            GLES20.glCompileShader((int)n);
            int[] nArray = new int[1];
            GLES20.glGetShaderiv((int)n, (int)35713, (int[])nArray, (int)0);
            if (nArray[0] == 0) {
                string = GLES20.glGetShaderInfoLog((int)n);
                GLES20.glDeleteShader((int)n);
            }
        }
        if (n == 0) {
            MDLog.e((String)TAG, (String)("could not create new shader. Reason : \n" + string));
        }
        return n;
    }
}

