/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.helper;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class ImageHelper {
    public static int bitmapToTexture(Bitmap bitmap) {
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        GLES20.glBindTexture((int)3553, (int)nArray[0]);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
        if (bitmap != null) {
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        }
        return nArray[0];
    }

    public static void updateBitmap(Bitmap bitmap, int textid) {
        GLES20.glBindTexture((int)3553, (int)textid);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
        if (bitmap != null) {
            GLUtils.texSubImage2D((int)3553, (int)0, (int)0, (int)0, (Bitmap)bitmap);
        }
    }

    public static Bitmap getBitmapByPath(String path) {
        return ImageHelper.decodeFile(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bitmap decodeFile(String pathName) {
        Bitmap bitmap = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(pathName);
            bitmap = BitmapFactory.decodeStream((InputStream)fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return bitmap;
    }
}

