/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.skin;

import android.graphics.Point;
import project.android.imageprocessing.filter.GroupFilter;
import project.android.imageprocessing.filter.colour.SaturationFilter;
import project.android.imageprocessing.filter.colour.ToneCurveFilter;
import project.android.imageprocessing.filter.skin.RangeSelectFilter;
import project.android.imageprocessing.filter.skin.SkinComposeFilter;

public class SkinSmoothingFilter
extends GroupFilter {
    private SkinComposeFilter skinComposeFilter;
    private float skinLevel = 0.8f;

    public SkinSmoothingFilter() {
        this.useNewViewPort = true;
        Point[] pointArray = new Point[]{new Point(0, 0), new Point(255, 255)};
        Point[] pointArray2 = new Point[]{new Point(0, 0), new Point(120, 146), new Point(255, 255)};
        SaturationFilter saturationFilter = new SaturationFilter(1.0f);
        ToneCurveFilter toneCurveFilter = new ToneCurveFilter(pointArray, pointArray, pointArray, pointArray2);
        RangeSelectFilter rangeSelectFilter = new RangeSelectFilter();
        this.skinComposeFilter = new SkinComposeFilter(0.8f);
        saturationFilter.addTarget(toneCurveFilter);
        saturationFilter.addTarget(rangeSelectFilter);
        saturationFilter.addTarget(this.skinComposeFilter);
        toneCurveFilter.addTarget(this.skinComposeFilter);
        rangeSelectFilter.addTarget(this.skinComposeFilter);
        this.skinComposeFilter.registerFilterLocation(saturationFilter, 0);
        this.skinComposeFilter.registerFilterLocation(toneCurveFilter, 1);
        this.skinComposeFilter.registerFilterLocation(rangeSelectFilter, 2);
        this.skinComposeFilter.addTarget(this);
        this.registerInitialFilter(saturationFilter);
        this.registerFilter(toneCurveFilter);
        this.registerFilter(rangeSelectFilter);
        this.registerTerminalFilter(this.skinComposeFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSmoothLevel(float level) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.skinComposeFilter.setMixValue(level);
        }
    }

    public float getSkinLevel() {
        return this.skinLevel;
    }
}

