/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.skin;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.MultiInputFilter;

public class SkinComposeFilter
extends MultiInputFilter {
    private static final String UNIFORM_MIX_LEVEL = "mixPercent";
    private int mixHandler;
    private float mixValue;

    public SkinComposeFilter() {
        super(3);
    }

    public SkinComposeFilter(float mixValue) {
        super(3);
        this.mixValue = mixValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMixValue(float mixValue) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.mixValue = mixValue;
        }
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nuniform sampler2D inputImageTexture2;\nvarying vec2 textureCoordinate;\nuniform float mixPercent;\nvoid main(){\n   vec4 image = texture2D(inputImageTexture0,textureCoordinate);\n   vec4 toneCurvedImage = texture2D(inputImageTexture1,textureCoordinate);\n   vec4 mask = texture2D(inputImageTexture2,textureCoordinate);\n    gl_FragColor = vec4(mix(image.rgb,toneCurvedImage.rgb,1.0 - mask.b*mixPercent),1.0);\n}\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.mixHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_MIX_LEVEL);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.mixHandler, (float)this.mixValue);
    }
}

