/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public class ZoomBlurTransFilter
extends BasicFilter {
    public static final String UNIFORM_TIME = "iTime";
    private int timeHandler;
    private float time = 0.0f;
    private boolean useInnerTime = true;
    private long duration = 100000L;

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float iTime;\n const float strength = 0.3;\n const float PI = 3.141592653589793;\n float Linear_ease(in float begin, in float change, in float duration, in float time) {\n    return change * time / duration + begin;\n }\n float Exponential_easeInOut(in float begin, in float change, in float duration, in float time) {\n    if (time == 0.0)\n        return begin;\n    else if (time == duration)\n        return begin + change;\n    time = time / (duration / 2.0);\n    if (time < 1.0)\n        return change / 2.0 * pow(2.0, 10.0 * (time - 1.0)) + begin;\n    return change / 2.0 * (-pow(2.0, -10.0 * (time - 1.0)) + 2.0) + begin;\n }\n float Sinusoidal_easeInOut(in float begin, in float change, in float duration, in float time) {\n    return -change / 2.0 * (cos(PI * time / duration) - 1.0) + begin;\n }\n float random(in vec3 scale, in float seed) {\n    return fract(sin(dot(gl_FragCoord.xyz + seed, scale)) * 43758.5453 + seed);\n }\n vec3 crossFade(in vec2 uv, in float dissolve) {\n    return mix(texture2D(inputImageTexture0, uv).rgb, texture2D(inputImageTexture0, uv).rgb, dissolve);\n }void main(){\n    vec2 texCoord = textureCoordinate;\n    float progress = sin(iTime*2.0) * 0.5 + 0.5;\n    vec2 center = vec2(Linear_ease(0.5, 0.0, 1.0, progress),0.5);\n    float dissolve = Exponential_easeInOut(0.0, 1.0, 1.0, progress);\n    float strength = Sinusoidal_easeInOut(0.0, strength, 0.5, progress);\n    vec3 color = vec3(0.0);\n    float total = 0.0;\n    vec2 toCenter = center - texCoord;\n    float offset = random(vec3(12.9898, 78.233, 151.7182), 0.0)*0.5;\n    for (float t = 0.0; t <= 20.0; t++) {\n        float percent = (t + offset) / 20.0;\n        float weight = 1.0 * (percent - percent * percent);\n        color += crossFade(texCoord + toCenter * percent * strength, dissolve) * weight;\n        total += weight;\n    }    gl_FragColor =vec4(color / total, 1.0);\n}";
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.timeHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TIME);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        if (this.useInnerTime) {
            this.time = (float)(System.currentTimeMillis() % this.duration) / 1000.0f;
        }
        GLES20.glUniform1f((int)this.timeHandler, (float)this.time);
    }
}

