/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.graphics.PointF;
import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public class ZoomBlurFilter
extends BasicFilter {
    private static final String UNIFORM_BLUR_SIZE = "u_BlurSize";
    private static final String UNIFORM_BLUR_LOCATION = "u_BlurLocation";
    float blurSize;
    PointF blurLocation;
    private int blurSizeHandle;
    private int blurLocationHandle;

    public ZoomBlurFilter(float blurSize, PointF blurLocation) {
        this.blurSize = blurSize;
        this.blurLocation = blurLocation;
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nvarying vec2 textureCoordinate;\nuniform float u_BlurSize;\nuniform vec2 u_BlurLocation;\nvoid main(){\n   vec2 samplingOffset = 1.0/100.0 * (u_BlurLocation - textureCoordinate) * u_BlurSize;\n   vec4 fragColour = texture2D(inputImageTexture0, textureCoordinate) * 0.18;\n   fragColour += texture2D(inputImageTexture0, textureCoordinate +  samplingOffset) * 0.15;\n   fragColour += texture2D(inputImageTexture0, textureCoordinate -  samplingOffset) * 0.15;\n   fragColour += texture2D(inputImageTexture0, textureCoordinate +  (2.0 * samplingOffset)) * 0.12;\n   fragColour += texture2D(inputImageTexture0, textureCoordinate -  (2.0 * samplingOffset)) * 0.12;\n   fragColour += texture2D(inputImageTexture0, textureCoordinate +  (3.0 * samplingOffset)) * 0.09;\n   fragColour += texture2D(inputImageTexture0, textureCoordinate -  (3.0 * samplingOffset)) * 0.09;\n   fragColour += texture2D(inputImageTexture0, textureCoordinate +  (4.0 * samplingOffset)) * 0.05;\n   fragColour += texture2D(inputImageTexture0, textureCoordinate -  (4.0 * samplingOffset)) * 0.05;\n   gl_FragColor = fragColour;\n}\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.blurSizeHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_BLUR_SIZE);
        this.blurLocationHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_BLUR_LOCATION);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.blurSizeHandle, (float)this.blurSize);
        GLES20.glUniform2f((int)this.blurLocationHandle, (float)this.blurLocation.x, (float)this.blurLocation.y);
    }
}

