/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.AbsEffectOptionFilter;

public class WaterReflectionFilter
extends AbsEffectOptionFilter {
    public static final String UNIFORM_TIME = "iTime";
    private int timeHandler;
    private float time = 0.0f;
    private long duration = 100000L;

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float iTime;\nvoid main(){\n vec2 uv = textureCoordinate;\n vec4 waterColor = vec4(1.0);\n    float reflactionY = 0.5;\n    if(uv.y <= reflactionY)\n    {        \n        float oy = uv.y;\n        uv.y = 2.0*reflactionY - uv.y;\n        uv.y = uv.y + sin(1./(oy-reflactionY)+iTime*10.0)*0.005;\n        waterColor = vec4(0.75,0.85, 0.95,1.0);\n    } gl_FragColor = texture2D(inputImageTexture0,uv)*waterColor;\n}";
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.timeHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TIME);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        this.time = (float)(System.currentTimeMillis() % this.duration) / 1000.0f;
        GLES20.glUniform1f((int)this.timeHandler, (float)this.time);
    }
}

