/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public class VertigoFilter
extends BasicFilter {
    public static final String UNIFORM_TIME = "iTime";
    private int timeHandler;
    private float time = 0.0f;
    private boolean useInnerTime = true;
    private long duration = 100000L;

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float iTime;\nvoid main(){\n vec2 uv = textureCoordinate;\n float magnitude = 0.02;\n vec3 color = texture2D(inputImageTexture0, uv).rgb; color += texture2D(inputImageTexture0, uv+vec2(sin(iTime*2.0)*magnitude - cos(iTime)*magnitude, 0.)).rgb; color /= 2.0;\n gl_FragColor = vec4(color,1.0);\n}";
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.timeHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TIME);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        if (this.useInnerTime) {
            this.time = (float)(System.currentTimeMillis() % this.duration) / 1000.0f;
        }
        GLES20.glUniform1f((int)this.timeHandler, (float)this.time);
    }
}

