/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.CompositeFilter;
import project.android.imageprocessing.filter.processing.GaussianBlurFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class UnsharpMaskFilter
extends CompositeFilter {
    private static final String UNIFORM_INTENSITY = "u_Intensity";
    private float intensity;
    private int intensityHandle;
    private GaussianBlurFilter blur;

    public UnsharpMaskFilter(float blurSize, float intensity) {
        super(2);
        this.intensity = intensity;
        this.blur = new GaussianBlurFilter(blurSize);
        this.blur.addTarget(this);
        this.registerInitialFilter(this.blur);
        this.registerTerminalFilter(this.blur);
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nvarying vec2 textureCoordinate;\nuniform float u_Intensity;\nvoid main(){\n   vec4 sharpImageColor = texture2D(inputImageTexture0, textureCoordinate);\n   vec4 blurredImageColor = texture2D(inputImageTexture1, textureCoordinate);\n   gl_FragColor = vec4(mix(sharpImageColor.rgb, blurredImageColor.rgb, u_Intensity), sharpImageColor.a);\n}\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.intensityHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_INTENSITY);
    }

    @Override
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        if (this.filterLocations.size() < 2 || !this.filterLocations.contains(source)) {
            this.clearRegisteredFilterLocations();
            this.registerFilterLocation(source, 0);
            this.registerFilterLocation(this.blur, 1);
            this.registerInputOutputFilter(source);
        }
        super.newTextureReady(texture, source, newData);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.intensityHandle, (float)this.intensity);
    }
}

