/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public class TransformFilter
extends BasicFilter {
    private static final String UNIFORM_TRANSFORM_MATRIX = "u_TransformMatrix";
    private static final String UNIFORM_ORTHO_MATRIX = "u_OrthoMatrix";
    private int transformMatrixHandle;
    private int orthoMatrixHandle;
    private float[] transformMatrix;
    private float[] orthoMatrix;
    private boolean ignoreAspect;
    private boolean anchorTopLeft;

    public TransformFilter(float[] transformMatrix, boolean ignoreAspect, boolean anchorTopLeft) {
        this.transformMatrix = transformMatrix;
        this.ignoreAspect = ignoreAspect;
        this.anchorTopLeft = anchorTopLeft;
    }

    @Override
    protected String getVertexShader() {
        return "attribute vec4 position;\nattribute vec2 inputTextureCoordinate;\nuniform mat4 u_OrthoMatrix;\nuniform mat4 u_TransformMatrix;\nvarying vec2 textureCoordinate;\nvoid main() {\n  textureCoordinate = inputTextureCoordinate;\n   gl_Position = u_TransformMatrix * vec4(position.xyz, 1.0) * u_OrthoMatrix;\n}\n";
    }

    @Override
    protected void handleSizeChange() {
        super.handleSizeChange();
        if (this.ignoreAspect) {
            if (this.anchorTopLeft) {
                this.setRenderVertices(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
            }
            this.loadOrthoMatrix(-1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f);
        } else {
            float f = (float)this.getHeight() / (float)this.getWidth();
            if (this.anchorTopLeft) {
                this.setRenderVertices(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, f, 1.0f, f});
            } else {
                this.setRenderVertices(new float[]{-1.0f, -f, 1.0f, -f, -1.0f, f, 1.0f, f});
            }
            this.loadOrthoMatrix(-1.0f, 1.0f, -1.0f * (float)this.getHeight() / (float)this.getWidth(), 1.0f * (float)this.getHeight() / (float)this.getWidth(), -1.0f, 1.0f);
        }
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.transformMatrixHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TRANSFORM_MATRIX);
        this.orthoMatrixHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_ORTHO_MATRIX);
    }

    private void loadOrthoMatrix(float left, float right, float bottom, float top, float near, float far) {
        float f = right - left;
        float f2 = top - bottom;
        float f3 = far - near;
        float f4 = -(right + left) / (right - left);
        float f5 = -(top + bottom) / (top - bottom);
        float f6 = -(far + near) / (far - near);
        float f7 = 2.0f;
        if (this.anchorTopLeft) {
            f7 = 4.0f;
            f4 = -1.0f;
            f5 = -1.0f;
        }
        this.orthoMatrix = new float[]{f7 / f, 0.0f, 0.0f, f4, 0.0f, f7 / f2, 0.0f, f5, 0.0f, 0.0f, f7 / f3, f6, 0.0f, 0.0f, 0.0f, 1.0f};
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniformMatrix4fv((int)this.transformMatrixHandle, (int)1, (boolean)false, (float[])this.transformMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.orthoMatrixHandle, (int)1, (boolean)false, (float[])this.orthoMatrix, (int)0);
    }
}

