/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.CompositeFilter;
import project.android.imageprocessing.filter.processing.GaussianBlurFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class TiltShiftFilter
extends CompositeFilter {
    protected static final String UNIFORM_FOCUS_FALLOFF = "u_FocusFalloff";
    protected static final String UNIFORM_TOP_FOCUS = "u_TopFocus";
    protected static final String UNIFORM_BOTTOM_FOCUS = "u_BottomFocus";
    private float focusFallOffRate;
    private float topFocusLevel;
    private float bottomFocusLevel;
    private int focusFallOffRateHandle;
    private int topFocusLevelHandle;
    private int bottomFocusLevelHandle;
    private GaussianBlurFilter blur;

    public TiltShiftFilter(float blurSize, float topFocusLevel, float bottomFocusLevel, float focusFallOffRate) {
        super(2);
        this.topFocusLevel = topFocusLevel;
        this.bottomFocusLevel = bottomFocusLevel;
        this.focusFallOffRate = focusFallOffRate;
        this.blur = new GaussianBlurFilter(blurSize);
        this.blur.addTarget(this);
        this.registerInitialFilter(this.blur);
        this.registerTerminalFilter(this.blur);
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nvarying vec2 textureCoordinate;\nuniform float u_FocusFalloff;\nuniform float u_TopFocus;\nuniform float u_BottomFocus;\nvoid main(){\n   vec4 sharpImageColor = texture2D(inputImageTexture0, textureCoordinate);\n   vec4 blurredImageColor = texture2D(inputImageTexture1, textureCoordinate);\n   float blurIntensity = 1.0 - smoothstep(u_TopFocus - u_FocusFalloff, u_TopFocus, textureCoordinate.y);\n   blurIntensity += smoothstep(u_BottomFocus, u_BottomFocus + u_FocusFalloff, textureCoordinate.y);\n   gl_FragColor = mix(sharpImageColor, blurredImageColor, blurIntensity);\n}\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.focusFallOffRateHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_FOCUS_FALLOFF);
        this.topFocusLevelHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TOP_FOCUS);
        this.bottomFocusLevelHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_BOTTOM_FOCUS);
    }

    @Override
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        if (this.filterLocations.size() < 2 || !this.filterLocations.contains(source)) {
            this.clearRegisteredFilterLocations();
            this.registerFilterLocation(source, 0);
            this.registerFilterLocation(this.blur, 1);
            this.registerInputOutputFilter(source);
        }
        super.newTextureReady(texture, source, newData);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.focusFallOffRateHandle, (float)this.focusFallOffRate);
        GLES20.glUniform1f((int)this.topFocusLevelHandle, (float)this.topFocusLevel);
        GLES20.glUniform1f((int)this.bottomFocusLevelHandle, (float)this.bottomFocusLevel);
    }
}

