/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.inter.IVideoTrackTime;

public class ThousandFaceFilter
extends BasicFilter
implements IVideoTrackTime {
    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\n#define R .09\n #define FISH 1.0\n #define SQRT3 1.732050807\n #define PI 3.141592653\n\nvec2 hexCenter(vec2 id, float odd)\n{\n    return vec2(\n        SQRT3 * R * (id.x +.5*odd),\n        1.5 * id.y * R\n        );\n}\nvoid main(){    float OFFSET =  0.1 + 4. * (1. - 0.0);\n    float FALLOFF = 0. + 0.5 * 0.0;\n    vec2 uv = textureCoordinate;\n    uv.xy += 1.0;\n    vec2 grid;\n    grid.y = floor(uv.y / (1.5*R));\n    float odd = mod(grid.y, 2.0);\n    grid.x = floor(uv.x / (SQRT3 * R) - odd*.5);\n    vec2 h1 = hexCenter(grid, odd);\n    vec2 h2 = hexCenter(grid + vec2(1.0,0.0), odd);\n    vec2 h3 = hexCenter(grid + vec2(odd, 1.0), 1.0-odd);\n    float d1 = dot(h1-uv, h1-uv);\n    float d2 = dot(h2-uv, h2-uv);\n    float d3 = dot(h3-uv, h3-uv);\n    if (d2 < d1)\n    {\n        d1 = d2;\n        h1 = h2;\n    }\n    if (d3 < d1)\n    {\n        d1 = d3;\n        h1 = h3;\n    }\n    vec2 uv2 = uv - h1;\n    uv = (uv.xy - 1.0) + uv2 * OFFSET;\n    vec2 coords = (uv2 - 0.5*R) * 2.0;\n    vec2 fisheye;\n    fisheye.x = (1.0 - coords.y * coords.y) * FISH * (coords.x);\n    fisheye.y = (1.0 - coords.x * coords.x) * FISH * (coords.y);\n    uv -= fisheye*R;\n    vec4 o = texture2D(inputImageTexture0, uv);\n    gl_FragColor = max(vec4(0.0), o - length(2.0*uv-1.0)*FALLOFF);\n}";
        return string;
    }

    @Override
    public void setTimeStamp(long ms) {
    }
}

