/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicEffectFilter;
import project.android.imageprocessing.inter.IVideoTrackTime;

public class SoulOutFilter
extends BasicEffectFilter
implements IVideoTrackTime {
    public static final String UNIFORM_TIME = "time";
    private int timeHandler;
    private float time = 0.0f;
    private long duration = 100000L;

    public SoulOutFilter() {
        this.mFilterId = 1;
    }

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float time;\nvec2 scaleFromCenter(vec2 coord, float scale) {\n  if (scale > 1.0 || scale < 0.0) { return coord; }\n  vec2 scaleCenter = vec2(0.5);\n  return (coord - scaleCenter) * scale + scaleCenter;\n}\nvoid main(){\n    vec2 st = textureCoordinate;\n  \n    float scale = 1.0 - mod(time * 1.3, 0.8) + 0.1;\n    if (scale < 0.0) {\n    gl_FragColor = texture2D(inputImageTexture0, st);\n    return;\n    }\n    vec2 newCoord = scaleFromCenter(st, scale);\n    float colorScale = scale * 0.5;\n    vec4 resultColor = texture2D(inputImageTexture0, st) * (1.0 - colorScale + 0.2);\n    vec4 newCoordColor = texture2D(inputImageTexture0, newCoord) * (colorScale - 0.2);\n    vec4 result = (resultColor + newCoordColor);\n    gl_FragColor = result;\n}\n";
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.timeHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TIME);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.timeHandler, (float)this.time);
    }

    @Override
    public void setTimeStamp(long ms) {
        super.setTimeStamp(ms);
        this.time = (float)ms / 1200.0f;
    }
}

