/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.inter.IVideoTrackTime;

public class ShiftImageFilter
extends BasicFilter
implements IVideoTrackTime {
    private static final String UNIFORM_START = "isStart";
    private int startHandle;
    private long mStartTime = 0L;
    private long mEndTime = 0L;
    private long mPlayTime = 0L;
    private int mCount = 0;
    private long mDuration = 10000L;

    public ShiftImageFilter(long mDuration) {
        this.mDuration = mDuration;
    }

    @Override
    protected String getFragmentShader() {
        String string = "precision mediump float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float isStart;\nvoid main(){\n float y = 0.0;\n if (isStart == 1.0) {   y = mod(textureCoordinate.y + 0.8, 1.0);\n } else {   y = textureCoordinate.y;\n }   vec4 color = texture2D(inputImageTexture0, vec2(textureCoordinate.x,y));\n   gl_FragColor = color;\n}\n";
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.mStartTime = System.currentTimeMillis();
        this.startHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_START);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        this.mEndTime = System.currentTimeMillis() - this.mStartTime;
        long l = this.mEndTime / this.mDuration;
        this.mEndTime -= l * this.mDuration;
        if (this.mEndTime >= this.mPlayTime && this.mCount < 3) {
            GLES20.glUniform1f((int)this.startHandle, (float)1.0f);
            ++this.mCount;
        } else if (this.mEndTime >= this.mPlayTime && this.mCount >= 3) {
            GLES20.glUniform1f((int)this.startHandle, (float)0.0f);
        } else {
            GLES20.glUniform1f((int)this.startHandle, (float)0.0f);
            this.mCount = 0;
        }
    }

    @Override
    public void setTimeStamp(long ms) {
    }

    public void setPlayTime(long ms) {
        this.mPlayTime = ms;
    }
}

