/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicEffectFilter;
import project.android.imageprocessing.inter.IVideoTrackTime;

public class ShakeFilter
extends BasicEffectFilter
implements IVideoTrackTime {
    public static final String UNIFORM_TIME = "iTime";
    private int timeHandler;
    private float time = 0.0f;
    private long duration = 100000L;

    public ShakeFilter() {
        this.mFilterId = 2;
    }

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float iTime;\nvec2 scaleFromCenter(vec2 coord, float scale) {\n  if (scale > 1.0 || scale < 0.0) { return coord; }\n  vec2 scaleCenter = vec2(0.55, 0.45);\n  return (coord - scaleCenter) * scale + scaleCenter;\n}\nvec2 scaleFromCenter2(vec2 coord, float scale) {\n  if (scale > 1.0 || scale < 0.0) { return coord; }\n  vec2 scaleCenter = vec2(0.5);\n  return (coord - scaleCenter) * scale + scaleCenter;\n}\nvec2 scaleFromCenter3(vec2 coord, float scale) {\n  if (scale > 1.0 || scale < 0.0) { return coord; }\n  vec2 scaleCenter = vec2(0.45);\n  return (coord - scaleCenter) * scale + scaleCenter;\n}void main(){\n    vec2 st = textureCoordinate;\n    float scale = 1.0 - mod(iTime * 1.0, 0.8) + 0.5;\n    if (scale < 0.0) {\n    gl_FragColor = texture2D(inputImageTexture0, st);\n    return;\n    }\n    vec2 newCoord = scaleFromCenter(st, scale);\n    vec4 result = texture2D(inputImageTexture0, newCoord);\n    vec2 newCoord2 = scaleFromCenter2(st, scale);\n    vec4 result2 = texture2D(inputImageTexture0, newCoord2);\n    vec2 newCoord3 = scaleFromCenter3(st, scale);\n    vec4 result3 = texture2D(inputImageTexture0, newCoord3);\n    vec4 xx = result * vec4(0.0,0.0,1.0,1.0) +    result2 * vec4(0.0,1.0,0.0,1.0) +    result3 * vec4(1.0,0.0,0.0,1.0);\n    gl_FragColor = vec4(xx.rgb,1.0);\n}\n";
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.timeHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TIME);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.timeHandler, (float)this.time);
    }

    @Override
    public void setTimeStamp(long ms) {
        super.setTimeStamp(ms);
        this.time = (float)ms / 1100.0f;
    }
}

