/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.inter.IVideoTrackTime;

public class RotoZoomerFilter
extends BasicFilter
implements IVideoTrackTime {
    public static final String UNIFORM_TIME = "iTime";
    private int timeHandler;
    private float time = 0.0f;
    private boolean useInnerTime = true;
    private long duration = 100000L;

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float iTime;\n#define PI 3.14159265359\n void main(){\n    vec2 uv = (textureCoordinate - 0.5) * 2.0;\n    float bendAngle = sin(iTime*0.1)*0.25*PI;\n    float z = (1.0-uv.y) * tan(bendAngle);\n    uv = uv / (z+1.0);\n    vec2 zoomUv = uv * ((sin(iTime)+1.0)*5.0+0.5);\n    float rotAngle = mod(iTime*0.2, 2.0*PI);\n    vec2 rotuv = vec2(\n        zoomUv.x * cos(rotAngle) - zoomUv.y * sin(rotAngle),\n        zoomUv.x * sin(rotAngle) + zoomUv.y * cos(rotAngle)\n    );\n    vec2 aspectCorrected = rotuv;\n    vec2 repRotUv = mod(aspectCorrected, 1.0);\n    vec4 camPx = texture2D(inputImageTexture0, repRotUv);\n    gl_FragColor = camPx;\n}";
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.timeHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TIME);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        if (this.useInnerTime) {
            this.time = (float)(System.currentTimeMillis() % this.duration) / 1000.0f;
        }
        GLES20.glUniform1f((int)this.timeHandler, (float)this.time);
    }

    @Override
    public void setTimeStamp(long ms) {
        long l = ms % this.duration;
        this.time = (float)l / 1000.0f;
        this.useInnerTime = false;
    }
}

