/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.inter.IVideoTrackTime;

public class RGBKernelFilter
extends BasicFilter
implements IVideoTrackTime {
    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nvoid main(){\n vec2 uv = textureCoordinate;\n    mat3 kernelr = mat3(\n        vec3(-1., -1., -1.),\n        vec3( 2.,  2.,  2.),\n        vec3(-1., -1., -1.)\n    );\n    mat3 kernelg = mat3(\n        vec3(-1.,  2., -1.),\n        vec3(-1.,  2., -1.),\n        vec3(-1.,  2., -1.)\n    );\n    mat3 kernelb = mat3(\n        vec3( 0.,  0.,  0.),\n        vec3( 0.,  0.,  0.),\n        vec3( 0.,  0.,  0.)\n    );\n    vec3 sum = vec3(0);\n    for(int x = -1; x <= 1; ++x)\n    {\n        for(int y = -1; y <= 1; ++y)\n        {\n            vec3 val3 = texture2D(inputImageTexture0, vec2(x,y) / 1000. + uv).rgb;\n            float val = (val3.r + val3.g + val3.b) / 3.;\n            \n            sum.r += val * kernelr[x][y];\n            sum.g += val * kernelg[x][y];\n            sum.b += val * kernelb[x][y];\n        }\n    }\n    vec3 act = sum  * 5.;\n    gl_FragColor = vec4(act,1.0);\n}\n";
        return string;
    }

    @Override
    public void setTimeStamp(long ms) {
    }
}

