/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public class OverburstFilter
extends BasicFilter {
    public static final String UNIFORM_TIME = "iTime";
    private int timeHandler;
    private float time = 0.0f;
    private boolean useInnerTime = true;
    private long duration = 100000L;

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float iTime;\nvoid main(){\n    vec3 u_color = vec3(1.0, 1.0, 1.0);\n    vec2 i_uv = textureCoordinate;\n    vec3 textureColor = texture2D(inputImageTexture0, i_uv).xyz;\n    float u_ambientStrength = 0.05;\n    vec3 ambientColor = u_color * u_ambientStrength;\n    vec3 u_lightColor = vec3(1.0, 1.0, 1.0);\n    vec3 i_lightDirection = vec3(1.0, 1.0, 1.0);\n    vec3 i_normalDirection = vec3(1.0, 1.0, 1.0);\n    vec3 lightDirection = normalize(i_lightDirection);\n    vec3 normalDirection = normalize(i_normalDirection);\n    vec3 diffuseColor = u_lightColor * max(dot(normalDirection, lightDirection), 0.0);\n    float u_shininess = 32.0;\n    vec3 u_specularIntensity = vec3(1.0, 1.0, 1.0);\n    vec3 u_specularMaterial = vec3(1.0, 1.0, 1.0);\n    vec3 i_cameraPosition = vec3(-(0.5+0.5*sin(5.0*iTime)), -1.0, -1.0);\n    vec3 viewDirection = normalize(normalDirection - i_cameraPosition);\n    vec3 reflectionDirection = reflect(-lightDirection, normalDirection);\n    float spec = pow(max(dot(viewDirection, reflectionDirection), 0.0), u_shininess);\n    vec3 specularColor = u_lightColor * spec * u_specularIntensity * u_specularMaterial;    gl_FragColor = vec4(textureColor * (ambientColor + diffuseColor + specularColor), 1.0);\n}";
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.timeHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TIME);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        if (this.useInnerTime) {
            this.time = (float)(System.currentTimeMillis() % this.duration) / 1000.0f;
        }
        GLES20.glUniform1f((int)this.timeHandler, (float)this.time);
    }
}

