/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import project.android.imageprocessing.filter.MultiPixelRenderer;

public class MotionBlurFilter
extends MultiPixelRenderer {
    private float blurSize;
    private float degree;

    public MotionBlurFilter(float blurSize, float degree) {
        this.blurSize = blurSize;
        this.degree = degree;
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float u_TexelWidth;\nuniform float u_TexelHeight;\nvoid main(){\n   vec2 step = vec2(u_TexelWidth, u_TexelHeight);\n   vec4 fragColour = texture2D(inputImageTexture0, textureCoordinate) * 0.18;\n   fragColour += texture2D(inputImageTexture0, textureCoordinate + step) * 0.15;\n   fragColour += texture2D(inputImageTexture0, textureCoordinate - step) * 0.15;\n   fragColour += texture2D(inputImageTexture0, textureCoordinate + step * 2.0) * 0.12;\n   fragColour += texture2D(inputImageTexture0, textureCoordinate - step * 2.0) * 0.12;\n   fragColour += texture2D(inputImageTexture0, textureCoordinate + step * 3.0) * 0.09;\n   fragColour += texture2D(inputImageTexture0, textureCoordinate - step * 3.0) * 0.09;\n   fragColour += texture2D(inputImageTexture0, textureCoordinate + step * 4.0) * 0.05;\n   fragColour += texture2D(inputImageTexture0, textureCoordinate - step * 4.0) * 0.05;\n   gl_FragColor = fragColour;\n}\n";
    }

    @Override
    protected void handleSizeChange() {
        super.handleSizeChange();
        this.texelWidth = (float)((double)this.blurSize * Math.cos((double)this.degree * Math.PI / 180.0)) / (float)this.getWidth();
        this.texelHeight = (float)((double)this.blurSize * Math.sin((double)this.degree * Math.PI / 180.0)) / (float)this.getHeight();
    }
}

