/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.AbsEffectOptionFilter;
import project.android.imageprocessing.model.FilterOptions;

public class MirrorPermutationFilter
extends AbsEffectOptionFilter {
    private int numberHandle;
    private int number;

    @Override
    public void setFilterOptions(FilterOptions options) {
        super.setFilterOptions(options);
        this.number = options.getType();
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\n\nvarying vec2 textureCoordinate;\nuniform sampler2D inputImageTexture0;\nuniform float number;\n\nfloat pick(float val) {\n    if (val > 0.5) {\n        val = val - 0.5;\n    }\n    return val * 2.0;\n}\n\nfloat permutation(float val, float offset, float num, float base, float max) {\n    while (val > base) {\n        val = val - base;\n    }\n    return offset + val * num * max;\n}\n\nvoid main() {\n    vec2 uv = textureCoordinate;\n    if (number == 1.0) {\n        if(uv.x > 0.5) {\n            uv.x = 1.0 - uv.x;\n        }\n        uv.x = uv.x + 0.25;\n    } else if (number == 2.0) {\n        float base = 1.0 / number;\n        uv.y = permutation(uv.y, base, number, base, base);\n    } else if (number == 3.0) {\n        uv = vec2(pick(uv.x), pick(uv.y));\n        if(textureCoordinate.x > 0.5) {\n            uv.x = 1.0 - uv.x;\n        }\n        if(textureCoordinate.y <= 0.5) {\n            uv.y = 1.0 - uv.y;\n        }\n    }\n    vec4 result = texture2D(inputImageTexture0, uv);\n    gl_FragColor = result;\n\n}\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.numberHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"number");
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.numberHandle, (float)this.number);
    }
}

