/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.inter.IVideoTrackTime;

public class LensDistortionFilter
extends BasicFilter
implements IVideoTrackTime {
    public static final String UNIFORM_TIME = "time";
    private int timeHandler;
    private float time = 0.0f;
    private boolean useInnerTime = true;
    private long duration = 100000L;

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float time;\nvec2 computeUV( vec2 uv, float k, float kcube ){\n    \n    vec2 t = uv - .5;\n    float r2 = t.x * t.x + t.y * t.y;\n\tfloat f = 0.;\n    \n    if( kcube == 0.0){\n        f = 1. + r2 * k;\n    }else{\n        f = 1. + r2 * ( k + kcube * sqrt( r2 ) );\n    }\n    \n    vec2 nUv = f * t + .5;\n    //nUv.y = 1. - nUv.y;\n \n    return nUv;\n    \n}\nvoid main(){\nvec2 uv = textureCoordinate;\n  float k = 1.0 * 1.0/(tan( time * .9 ));\n    float kcube = .5 * sin( time );\n    \n    float offset = .1 * tan( time * .5 );\nfloat red = texture2D(inputImageTexture0,computeUV( uv, k + offset, kcube ) ).r;\nfloat green = texture2D(inputImageTexture0,computeUV( uv, k, kcube ) ).g;\nfloat blue = texture2D(inputImageTexture0,computeUV( uv, k - offset, kcube ) ).b;\ngl_FragColor = vec4(red,green,blue,1.0);\n}\n";
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.timeHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TIME);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        if (this.useInnerTime) {
            this.time = (float)(System.currentTimeMillis() % this.duration) / 1000.0f;
        }
        GLES20.glUniform1f((int)this.timeHandler, (float)this.time);
    }

    @Override
    public void setTimeStamp(long ms) {
        long l = ms % this.duration;
        this.time = (float)l / 1000.0f;
        this.useInnerTime = false;
    }
}

