/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public class ImageAdjustFilter
extends BasicFilter {
    private static final float WEIGHT_AMP = 3.0f;
    private int mWidthStepLocation;
    private int mHeightStepLocation;
    private int mWidthLocation;
    private int mWeightLocation;
    private int mEnabledLocation;
    private int mSaturationLocation;
    private int mContrastLocation;
    private int mThresholdLocation;
    private float mDeblurWeight = 0.4f;
    private int mDeblurRadius = 1;
    private float mDeblurThreshold = 0.012f;
    private float mSaturation = 1.2f;
    private float mContrast = 0.0f;
    private boolean mDeblurEnabled = false;

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\n\nvarying vec2 textureCoordinate;\nuniform sampler2D inputImageTexture0;\n\nuniform float heightInv;\nuniform float widthInv;\nuniform int width;\nuniform bool deblurEnabled;\nuniform float weight;\nuniform float threshold;\nuniform float saturation;\nuniform float contrast;\nconst vec3 luminanceWeighting = vec3(0.2125, 0.7154, 0.0721);\n\nvoid main() {\n    vec4 outColor;\n    vec4 origin = texture2D(inputImageTexture0, textureCoordinate);\n    outColor = origin;\n    if (deblurEnabled) {\n        vec4 imageH = origin\n            - (texture2D(inputImageTexture0, clamp(textureCoordinate+vec2(-widthInv,-heightInv),0.0,1.0))*0.08\n            +texture2D(inputImageTexture0, clamp(textureCoordinate+vec2(      0.0,-heightInv),0.0,1.0))*0.12\n            +texture2D(inputImageTexture0, clamp(textureCoordinate+vec2( widthInv,-heightInv),0.0,1.0))*0.08\n            +texture2D(inputImageTexture0, clamp(textureCoordinate+vec2(-widthInv,       0.0),0.0,1.0))*0.12\n            +texture2D(inputImageTexture0, clamp(textureCoordinate+vec2( widthInv,       0.0),0.0,1.0))*0.12\n            +texture2D(inputImageTexture0, clamp(textureCoordinate+vec2(-widthInv, heightInv),0.0,1.0))*0.08\n            +texture2D(inputImageTexture0, clamp(textureCoordinate+vec2(      0.0, heightInv),0.0,1.0))*0.12\n            +texture2D(inputImageTexture0, clamp(textureCoordinate+vec2( widthInv, heightInv),0.0,1.0))*0.08\n            +origin*0.2);\n        vec4 diff = abs(imageH);\n        float minVal = min(diff.r, min(diff.g, diff.b));\n        float temp = step(minVal, threshold);\n        vec4 imageM = temp * origin + ((1.0 - temp) * clamp(origin + imageH * weight, 0.0, 1.0));\n        outColor = imageM;\n\n        if (saturation > 0.0) {\n            float luminance = dot(imageM.rgb,luminanceWeighting);\n            vec3 greyScaleColor = vec3(luminance);\n            vec4 imageS=vec4(mix(greyScaleColor,imageM.rgb,saturation), imageM.a);\n            outColor = imageS;\n        }\n        if (contrast > 0.0) {            outColor = vec4(((outColor.rgb - vec3(0.5)) * contrast + vec3(0.5)), outColor.a);\n        }\n    }\n    gl_FragColor = outColor;\n}\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.mWidthStepLocation = GLES20.glGetUniformLocation((int)this.programHandle, (String)"widthInv");
        this.mHeightStepLocation = GLES20.glGetUniformLocation((int)this.programHandle, (String)"HeightInv");
        this.mWidthLocation = GLES20.glGetUniformLocation((int)this.programHandle, (String)"width");
        this.mWeightLocation = GLES20.glGetUniformLocation((int)this.programHandle, (String)"weight");
        this.mThresholdLocation = GLES20.glGetUniformLocation((int)this.programHandle, (String)"threshold");
        this.mSaturationLocation = GLES20.glGetUniformLocation((int)this.programHandle, (String)"saturation");
        this.mContrastLocation = GLES20.glGetUniformLocation((int)this.programHandle, (String)"contrast");
        this.mEnabledLocation = GLES20.glGetUniformLocation((int)this.programHandle, (String)"deblurEnabled");
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        float f = 1.0f / (float)this.getWidth();
        float f2 = 1.0f / (float)this.getHeight();
        GLES20.glUniform1f((int)this.mWidthStepLocation, (float)f);
        GLES20.glUniform1f((int)this.mHeightStepLocation, (float)f2);
        GLES20.glUniform1i((int)this.mWidthLocation, (int)this.getWidth());
        GLES20.glUniform1f((int)this.mWeightLocation, (float)(this.mDeblurWeight * 3.0f));
        GLES20.glUniform1f((int)this.mThresholdLocation, (float)this.mDeblurThreshold);
        GLES20.glUniform1f((int)this.mSaturationLocation, (float)this.mSaturation);
        GLES20.glUniform1f((int)this.mContrastLocation, (float)this.mContrast);
        GLES20.glUniform1i((int)this.mEnabledLocation, (int)(this.mDeblurEnabled ? 1 : 0));
    }

    public void setEnable(boolean enable) {
        this.mDeblurEnabled = enable;
    }

    public void setSaturation(float saturation) {
        this.mSaturation = saturation;
    }

    public void setSharpening(float sharpening) {
        this.mDeblurWeight = sharpening;
    }

    public void setContrast(float contrast) {
        this.mContrast = contrast;
    }
}

