/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public class HeartFeltFilter
extends BasicFilter {
    public static final String UNIFORM_TIME = "iTime";
    public static final String UNIFORM_WIDTH = "width";
    public static final String UNIFORM_HEIGHT = "height";
    private int timeHandler;
    private int widthHandler;
    private int heightHandler;
    private float time = 0.0f;
    private long duration = 100000L;

    @Override
    protected String getFragmentShader() {
        String string = "#define S(a, b, t) smoothstep(a, b, t)\n#define HAS_HEART\n#define USE_POST_PROCESSING\nprecision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float iTime;\nuniform float width;\nuniform float height;\nvec3 N13(float p) {\n   vec3 p3 = fract(vec3(p) * vec3(.1031,.11369,.13787));\n   p3 += dot(p3, p3.yzx + 19.19);\n   return fract(vec3((p3.x + p3.y)*p3.z, (p3.x+p3.z)*p3.y, (p3.y+p3.z)*p3.x));\n}\n\nvec4 N14(float t) {\n\treturn fract(sin(t*vec4(123., 1024., 1456., 264.))*vec4(6547., 345., 8799., 1564.));\n}\nfloat N(float t) {\n    return fract(sin(t*12345.564)*7658.76);\n}\n\nfloat Saw(float b, float t) {\n\treturn S(0., b, t)*S(1., b, t);\n}\n\n\nvec2 DropLayer2(vec2 uv, float t) {\n    vec2 UV = uv;\n    \n    uv.y += t*0.75;\n    vec2 a = vec2(6., 1.);\n    vec2 grid = a*2.;\n    vec2 id = floor(uv*grid);\n    \n    float colShift = N(id.x); \n    uv.y += colShift;\n    \n    id = floor(uv*grid);\n    vec3 n = N13(id.x*35.2+id.y*2376.1);\n    vec2 st = fract(uv*grid)-vec2(.5, 0);\n    \n    float x = n.x-.5;\n    \n    float y = UV.y*20.;\n    float wiggle = sin(y+sin(y));\n    x += wiggle*(.5-abs(x))*(n.z-.5);\n    x *= .7;\n    float ti = fract(t+n.z);\n    y = (Saw(.85, ti)-.5)*.9+.5;\n    vec2 p = vec2(x, y);\n    \n    float d = length((st-p)*a.yx);\n    \n    float mainDrop = S(.4, .0, d);\n    \n    float r = sqrt(S(1., y, st.y));\n    float cd = abs(st.x-x);\n    float trail = S(.23*r, .15*r*r, cd);\n    float trailFront = S(-.02, .02, st.y-y);\n    trail *= trailFront*r*r;\n    \n    y = UV.y;\n    float trail2 = S(.2*r, .0, cd);\n    float droplets = max(0., (sin(y*(1.-y)*120.)-st.y))*trail2*trailFront*n.z;\n    y = fract(y*10.)+(st.y-.5);\n    float dd = length(st-vec2(x, y));\n    droplets = S(.3, 0., dd);\n    float m = mainDrop+droplets*r*trailFront;\n    return vec2(m, trail);\n}\n\nfloat StaticDrops(vec2 uv, float t) {\n\tuv *= 40.;\n    \n    vec2 id = floor(uv);\n    uv = fract(uv)-.5;\n    vec3 n = N13(id.x*107.45+id.y*3543.654);\n    vec2 p = (n.xy-.5)*.7;\n    float d = length(uv-p);\n    \n    float fade = Saw(.025, fract(t+n.z));\n    float c = S(.3, 0., d)*fract(n.z*10.)*fade;\n    return c;\n}\n\nvec2 Drops(vec2 uv, float t, float l0, float l1, float l2) {\n    float s = StaticDrops(uv, t)*l0; \n    vec2 m1 = DropLayer2(uv, t)*l1;\n    vec2 m2 = DropLayer2(uv*1.85, t)*l2;\n    \n    float c = s+m1.x+m2.x;\n    c = S(.3, 1., c);\n    \n    return vec2(c, max(m1.y*l0, m2.y*l1));\n}\nvoid main(){\n vec2 uv = (textureCoordinate * vec2(width,height) - 0.5 * vec2(width,height))/height;\n vec2 UV = textureCoordinate;\n vec3 M = vec3(0.5,0.5,0.0);\n float T = iTime+M.x*2.;\n #ifdef HAS_HEART\n    T = mod(iTime, 102.);\n    T = mix(T, M.x*102., M.z>0.?1.:0.);\n    #endif\n    \n    \n    float t = T*.2;\n    \n    float rainAmount = sin(T*.05)*.3+.7;\n    \n    \n    float story = 0.;\n    float heart = 0.;\n    \n    #ifdef HAS_HEART\n    story = S(0., 70., T);\n    \n    t = min(1., T/70.);// remap drop time so it goes slower when it freezes\n    t = 1.-t;\n    t = (1.-t*t)*70.;\n    \n    float zoom= mix(.3, 1.2, story);// slowly zoom out\n    uv *=zoom;\n    \n    vec2 hv = uv-vec2(.0, -.1);// build heart\n    hv.x *= .5;\n    float s = S(110., 70., T);// heart gets smaller and fades towards the end\n    hv.y-=sqrt(abs(hv.x))*.5*s;\n    heart = length(hv);\n    heart = S(.4*s, .2*s, heart)*s;\n    rainAmount = heart;// the rain is where the heart is\n    \n    uv *= 1.5;// zoom out a bit more\n    t *= .25;\n    #else\n    float zoom = -cos(T*.2);\n    uv *= .7+zoom*.3;\n    #endif\n    UV = (UV-.5)*(.9+zoom*.1)+.5;\n    float staticDrops = S(-.5, 1., rainAmount)*2.;\n    float layer1 = S(.25, .75, rainAmount);\n    float layer2 = S(.0, .5, rainAmount);\n    vec2 c = Drops(uv, t, staticDrops, layer1, layer2);\n   #ifdef CHEAP_NORMALS\n    vec2 n = vec2(dFdx(c.x), dFdy(c.x));// cheap normals (3x cheaper, but 2 times shittier ;))\n    #else\n    vec2 e = vec2(.001, 0.);\n    float cx = Drops(uv+e, t, staticDrops, layer1, layer2).x;\n    float cy = Drops(uv+e.yx, t, staticDrops, layer1, layer2).x;\n    vec2 n = vec2(cx-c.x, cy-c.x);// expensive normals\n    #endif\n    #ifdef HAS_HEART\n    n *= 1.-S(60., 85., T);\n    c.y *= 1.-S(80., 100., T)*.8;\n    #endif\n    \n    vec3 col = texture2D(inputImageTexture0, UV+n).rgb;\n    #ifdef USE_POST_PROCESSING\n    t = (T+3.)*.5;// make time sync with first lightnoing\n    float colFade = sin(t*.2)*.5+.5+story;\n    col *= mix(vec3(1.), vec3(.8, .9, 1.3), colFade);\t// subtle color shift\n    float fade = S(0., 10., T);// fade in at the start\n    float lightning = sin(t*sin(t*10.));// lighting flicker\n    lightning *= pow(max(0., sin(t+sin(t))), 10.);// lightning flash\n    col *= 1.+lightning*fade*mix(1., .1, story*story);// composite lightning\n    col *= 1.-dot(UV-=.5, UV);// vignette\n    #ifdef HAS_HEART\n    \tcol = mix(pow(col, vec3(1.2)), col, heart);\n    \tfade *= S(102., 97., T);\n    #endif\n    \n    col *= fade;// composite start and end fade\n    #endif\n    \n    gl_FragColor = vec4(col, 1.);\n}";
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.timeHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TIME);
        this.widthHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_WIDTH);
        this.heightHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_HEIGHT);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        this.time = (float)(System.currentTimeMillis() % this.duration) / 1000.0f;
        GLES20.glUniform1f((int)this.timeHandler, (float)this.time);
        GLES20.glUniform1f((int)this.timeHandler, (float)this.time);
        GLES20.glUniform1f((int)this.widthHandler, (float)this.getWidth());
        GLES20.glUniform1f((int)this.heightHandler, (float)this.getHeight());
    }
}

