/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.graphics.PointF;
import project.android.imageprocessing.filter.processing.GaussianBlurPositionFilter;

public class GaussianSelectiveBlurFilter
extends GaussianBlurPositionFilter {
    public GaussianSelectiveBlurFilter(float blurSize, float aspectRatio, PointF excludedCirclePoint, float excludedCircleRadius, float excludedBlurSize) {
        super(blurSize, aspectRatio, excludedCirclePoint, excludedCircleRadius, excludedBlurSize);
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nvarying vec2 textureCoordinate;\nuniform float u_BlurSize;\nuniform float u_AspectRatio;\nuniform vec2 u_ExcludeCirclePoint;\nuniform float u_ExcludeCircleRadius;\nvoid main(){\n   vec4 sharpImageColor = texture2D(inputImageTexture0, textureCoordinate);\n   vec4 blurredImageColor = texture2D(inputImageTexture1, textureCoordinate);\n   vec2 texCoordAfterAspect = vec2(textureCoordinate.x, textureCoordinate.y * u_AspectRatio + 0.5 - 0.5 * u_AspectRatio);\n   float distanceFromCenter = distance(u_ExcludeCirclePoint, texCoordAfterAspect);\n   gl_FragColor = mix(sharpImageColor, blurredImageColor, smoothstep(u_ExcludeCircleRadius - u_BlurSize, u_ExcludeCircleRadius, distanceFromCenter));\n}\n";
    }
}

