/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.graphics.PointF;
import android.opengl.GLES20;
import project.android.imageprocessing.filter.CompositeFilter;
import project.android.imageprocessing.filter.processing.GaussianBlurFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class GaussianBlurPositionFilter
extends CompositeFilter {
    protected static final String UNIFORM_BLUR_SIZE = "u_BlurSize";
    protected static final String UNIFORM_ASPECT_RATIO = "u_AspectRatio";
    protected static final String UNIFORM_EXCLUDE_CIRCLE_POINT = "u_ExcludeCirclePoint";
    protected static final String UNIFORM_EXCLUDE_CIRCLE_RADIUS = "u_ExcludeCircleRadius";
    private float blurSize;
    private float aspectRatio;
    private PointF excludedCirclePoint;
    private float excludedCircleRadius;
    private int blurSizeHandle;
    private int aspectRatioHandle;
    private int excludedCirclePointHandle;
    private int excludedCircleRadiusHandle;
    private GaussianBlurFilter blur;

    public GaussianBlurPositionFilter(float blurSize, float aspectRatio, PointF excludedCirclePoint, float excludedCircleRadius, float excludedBlurSize) {
        super(2);
        this.blurSize = excludedBlurSize;
        this.aspectRatio = aspectRatio;
        this.excludedCirclePoint = excludedCirclePoint;
        this.excludedCircleRadius = excludedCircleRadius;
        this.blur = new GaussianBlurFilter(blurSize);
        this.blur.addTarget(this);
        this.registerInitialFilter(this.blur);
        this.registerTerminalFilter(this.blur);
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nvarying vec2 textureCoordinate;\nuniform float u_BlurSize;\nuniform float u_AspectRatio;\nuniform vec2 u_ExcludeCirclePoint;\nuniform float u_ExcludeCircleRadius;\nvoid main(){\n   vec4 sharpImageColor = texture2D(inputImageTexture0, textureCoordinate);\n   vec4 blurredImageColor = texture2D(inputImageTexture1, textureCoordinate);\n   vec2 texCoordAfterAspect = vec2(textureCoordinate.x, textureCoordinate.y * u_AspectRatio + 0.5 - 0.5 * u_AspectRatio);\n   float distanceFromCenter = distance(u_ExcludeCirclePoint, texCoordAfterAspect);\n   gl_FragColor = mix(blurredImageColor, sharpImageColor, smoothstep(u_ExcludeCircleRadius - u_BlurSize, u_ExcludeCircleRadius, distanceFromCenter));\n}\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.blurSizeHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_BLUR_SIZE);
        this.aspectRatioHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_ASPECT_RATIO);
        this.excludedCirclePointHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_EXCLUDE_CIRCLE_POINT);
        this.excludedCircleRadiusHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_EXCLUDE_CIRCLE_RADIUS);
    }

    @Override
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        if (this.filterLocations.size() < 2 || !this.filterLocations.contains(source)) {
            this.clearRegisteredFilterLocations();
            this.registerFilterLocation(source, 0);
            this.registerFilterLocation(this.blur, 1);
            this.registerInputOutputFilter(source);
        }
        super.newTextureReady(texture, source, newData);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.blurSizeHandle, (float)this.blurSize);
        GLES20.glUniform1f((int)this.aspectRatioHandle, (float)this.aspectRatio);
        GLES20.glUniform1f((int)this.excludedCircleRadiusHandle, (float)this.excludedCircleRadius);
        GLES20.glUniform2f((int)this.excludedCirclePointHandle, (float)this.excludedCirclePoint.x, (float)this.excludedCirclePoint.y);
    }
}

