/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.opengl.GLES20;
import java.nio.IntBuffer;
import project.android.imageprocessing.filter.TwoPassMultiPixelFilter;

public class GaussianBlurFilter
extends TwoPassMultiPixelFilter {
    private static final String UNIFORM_BLUR_SIZE = "u_BlurSize";
    private int blurSizeHandle;
    private float blurSize;

    public GaussianBlurFilter(float _blurRadiusInPixels) {
        _blurRadiusInPixels = 4.0f;
        if (_blurRadiusInPixels >= 1.0f) {
            float f = 0.00390625f;
            this.blurSize = (int)Math.floor(Math.sqrt(-2.0 * Math.pow(_blurRadiusInPixels, 2.0) * Math.log((double)f * Math.sqrt(Math.PI * 2 * Math.pow(_blurRadiusInPixels, 2.0)))));
            this.blurSize += this.blurSize % 2.0f;
        }
    }

    public static final String getVertexShader(float blurRadius, float sigma) {
        float[] fArray = new float[(int)(blurRadius + 2.0f)];
        float f = 0.0f;
        int n = 0;
        while ((float)n < blurRadius + 1.0f) {
            fArray[n] = (float)(1.0 / Math.sqrt(Math.PI * 2 * Math.pow(sigma, 2.0)) * Math.exp(-Math.pow(n, 2.0) / (2.0 * Math.pow(sigma, 2.0))));
            f = n == 0 ? (f += fArray[n]) : (float)((double)f + 2.0 * (double)fArray[n]);
            ++n;
        }
        n = 0;
        while ((float)n < blurRadius + 1.0f) {
            fArray[n] = fArray[n] / f;
            ++n;
        }
        n = (int)Math.min(blurRadius / 2.0f + blurRadius % 2.0f, 7.0f);
        IntBuffer intBuffer = IntBuffer.allocate(1);
        GLES20.glGetIntegerv((int)36348, (IntBuffer)intBuffer);
        if (intBuffer.get(0) > 0 && n > (intBuffer.get(0) - 2) / 2) {
            n = (intBuffer.get(0) - 2) / 2;
        }
        float[] fArray2 = new float[n];
        for (int i = 0; i < n; ++i) {
            float f2 = fArray[i * 2 + 1];
            float f3 = fArray[i * 2 + 2];
            float f4 = f2 + f3;
            fArray2[i] = (f2 * (float)(i * 2 + 1) + f3 * (float)(i * 2 + 2)) / f4;
        }
        StringBuffer stringBuffer = new StringBuffer().append("precision mediump float;\n      attribute vec4 position; \n      attribute vec4 inputTextureCoordinate; \n      uniform float texelWidthOffset; \n      uniform float texelHeightOffset; \n      varying vec2 blurCoordinates[" + (1 + n * 2) + "];" + "\n" + "      void main() \n" + "      {" + "          gl_Position = position; \n" + "          " + "          vec2 singleStepOffset = vec2(texelWidthOffset, texelHeightOffset);\n");
        stringBuffer.append("blurCoordinates[0] = inputTextureCoordinate.xy;\n");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("blurCoordinates[" + (i * 2 + 1) + "] = inputTextureCoordinate.xy + singleStepOffset *" + fArray2[i] + ";\n");
            stringBuffer.append("blurCoordinates[" + (i * 2 + 2) + "] = inputTextureCoordinate.xy - singleStepOffset *" + fArray2[i] + ";\n");
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public static final String getFragmentShader(float blurRadius, float sigma) {
        double d;
        double d2;
        double d3;
        int n;
        double[] dArray = new double[(int)(blurRadius + 2.0f)];
        float f = 0.0f;
        int n2 = 0;
        while ((float)n2 < blurRadius + 1.0f) {
            dArray[n2] = 1.0 / Math.sqrt(Math.PI * 2 * Math.pow(sigma, 2.0)) * Math.exp(-Math.pow(n2, 2.0) / (2.0 * Math.pow(sigma, 2.0)));
            f = n2 == 0 ? (float)((double)f + dArray[n2]) : (float)((double)f + 2.0 * dArray[n2]);
            ++n2;
        }
        n2 = 0;
        while ((float)n2 < blurRadius + 1.0f) {
            dArray[n2] = dArray[n2] / (double)f;
            ++n2;
        }
        n2 = (int)Math.min(blurRadius / 2.0f + blurRadius % 2.0f, 7.0f);
        int n3 = (int)(blurRadius / 2.0f + blurRadius % 2.0f);
        IntBuffer intBuffer = IntBuffer.allocate(1);
        GLES20.glGetIntegerv((int)36348, (IntBuffer)intBuffer);
        if (intBuffer.get(0) > 0 && n2 > (intBuffer.get(0) - 2) / 2) {
            n3 = n2 = (intBuffer.get(0) - 2) / 2;
        }
        StringBuffer stringBuffer = new StringBuffer().append("\n     precision mediump float;\n     uniform sampler2D inputImageTexture;\n     uniform float texelWidthOffset;\n     uniform float texelHeightOffset;\n     varying vec2 blurCoordinates[" + (1 + n2 * 2) + "];\n" + "     void main()" + "     {" + "        vec4 sum = vec4(0.0);\n");
        stringBuffer.append("sum += texture2D(inputImageTexture, blurCoordinates[0]) * " + dArray[0] + ";\n");
        for (n = 0; n < n2; ++n) {
            d3 = dArray[n * 2 + 1];
            d2 = dArray[n * 2 + 2];
            d = d3 + d2;
            stringBuffer.append("sum += texture2D(inputImageTexture, blurCoordinates[" + (n * 2 + 1) + "]) * (" + d + ");\n");
            stringBuffer.append("sum += texture2D(inputImageTexture, blurCoordinates[" + (n * 2 + 2) + "]) * (" + d + ");\n");
        }
        if (n3 > n2) {
            stringBuffer.append("highp vec2 singleStepOffset = vec2(texelWidthOffset, texelHeightOffset);\n");
            for (n = n2; n < n3; ++n) {
                d3 = dArray[n * 2 + 1];
                d2 = dArray[n * 2 + 2];
                d = d3 + d2;
                double d4 = (d3 * (double)(n * 2 + 1) + d2 * (double)(n * 2 + 2)) / d;
                stringBuffer.append("ssum += texture2D(inputImageTexture, blurCoordinates[0] + singleStepOffset *" + d4 + ")*" + d + ";\n");
            }
        }
        stringBuffer.append("gl_FragColor = sum;    }\n");
        return stringBuffer.toString();
    }

    @Override
    protected String getVertexShader() {
        return GaussianBlurFilter.getVertexShader(this.blurSize, this.blurSize);
    }

    @Override
    protected String getFragmentShader() {
        return GaussianBlurFilter.getFragmentShader(this.blurSize, this.blurSize);
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
    }
}

