/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.IntBuffer;
import project.android.imageprocessing.filter.BasicFilter;

public class FrameCoverFilter
extends BasicFilter {
    private CoverFrameCallback callback;
    private boolean isFristFrame = true;

    public void setCallback(CoverFrameCallback callback) {
        this.callback = callback;
    }

    @Override
    public void drawSub() {
        super.drawSub();
        if (this.isFristFrame) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (n2 > 0 && n > 0) {
                IntBuffer intBuffer = IntBuffer.allocate(n * n2);
                GLES20.glReadPixels((int)0, (int)0, (int)n, (int)n2, (int)6408, (int)5121, (Buffer)intBuffer);
                Bitmap bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bitmap.copyPixelsFromBuffer((Buffer)intBuffer);
                Matrix matrix = new Matrix();
                matrix.postScale(1.0f, -1.0f);
                matrix.postRotate(0.0f);
                bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n, (int)n2, (Matrix)matrix, (boolean)true);
                this.callback.bitmapCreated(bitmap);
            }
            this.isFristFrame = false;
        }
    }

    public static interface CoverFrameCallback {
        public void bitmapCreated(Bitmap var1);
    }
}

