/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.opengl.GLES20;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import project.android.imageprocessing.filter.BasicFilter;

public class FlipFilter
extends BasicFilter {
    public static final int FLIP_VERTICAL = 0;
    public static final int FLIP_HORIZONTAL = 1;
    public static final int FLIP_BOTH = 2;

    public FlipFilter(int flipDirection) {
        this.initTexCoord(flipDirection);
    }

    private void initTexCoord(int flipDirection) {
        this.textureVertices = new FloatBuffer[4];
        float f = 0.0f;
        float f2 = 1.0f;
        float f3 = 0.0f;
        float f4 = 1.0f;
        switch (flipDirection) {
            case 0: {
                f = 1.0f;
                f2 = 0.0f;
                break;
            }
            case 1: {
                f3 = 1.0f;
                f4 = 0.0f;
                break;
            }
            case 2: {
                f = 1.0f;
                f2 = 0.0f;
                f3 = 1.0f;
                f4 = 0.0f;
            }
        }
        float[] fArray = new float[]{f, f3, f2, f3, f, f4, f2, f4};
        this.textureVertices[0] = ByteBuffer.allocateDirect(fArray.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[0].put(fArray).position(0);
        float[] fArray2 = new float[]{f3, f2, f3, f, f4, f2, f4, f};
        this.textureVertices[1] = ByteBuffer.allocateDirect(fArray2.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[1].put(fArray2).position(0);
        float[] fArray3 = new float[]{f2, f4, f, f4, f2, f3, f, f3};
        this.textureVertices[2] = ByteBuffer.allocateDirect(fArray3.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[2].put(fArray3).position(0);
        float[] fArray4 = new float[]{f4, f, f4, f2, f3, f, f3, f2};
        this.textureVertices[3] = ByteBuffer.allocateDirect(fArray4.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[3].put(fArray4).position(0);
        for (int i = 0; i < 4; ++i) {
        }
    }

    public void setFlip(int flipDirection) {
        this.initTexCoord(flipDirection);
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.texture_in != 0) {
            int[] nArray = new int[]{this.texture_in};
            GLES20.glDeleteTextures((int)1, (int[])nArray, (int)0);
            this.texture_in = 0;
        }
    }
}

