/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.opengl.GLES20;
import java.io.File;
import project.android.imageprocessing.filter.AbsEffectOptionFilter;
import project.android.imageprocessing.helper.ImageHelper;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.model.FilterOptions;

public class FishEyeFilter
extends AbsEffectOptionFilter {
    private String[] imagePaths = new String[2];
    private int boxTextureHandler;
    private int bottomTextureHandler;
    private int ratioHandler;
    private int boxTexture;
    private int bottomTexture;

    @Override
    public void setFilterOptions(FilterOptions options) {
        super.setFilterOptions(options);
        this.imagePaths[0] = options.getFolder() + File.separator + "box.png";
        this.imagePaths[1] = options.getFolder() + File.separator + "bottom.png";
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nvarying vec2 textureCoordinate;\n\nuniform sampler2D inputImageTexture;\nuniform sampler2D boxTexture;\nuniform sampler2D bottomTexture;\nuniform vec2 ratio;\nfloat PI = 3.14159265358979323846;\n\nfloat rand(vec2 co) {\n    return fract(sin(dot(co.xy, vec2(12.9898, 78.233))) * 43758.5453);\n}\n\nvec4 getBg(sampler2D texture, vec2 uv) {\n    vec2 center = vec2(0.5, 0.5);\n    vec2 rr = uv + 0.01 * 1.4 * (uv - center);\n    vec2 bb = uv - 0.02 * 1.4 * (uv - center);\n\n    float r = texture2D(texture, clamp(rr, 0.0, 1.0)).r;\n    float g = texture2D(texture, uv).g;\n    float b = texture2D(texture, clamp(bb, 0.0, 1.0)).b;\n\n    return vec4(r, g, b, 1.0);\n}\n\nvec3 checker(vec2 uv) {\n    return getBg(inputImageTexture, uv).rgb;\n}\n\nvec3 checker2(vec2 uv) {\n    return vec3(0.0);\n}\n\nvec4 getColor(vec2 uv) {\n    float d = length(uv);\n    if (d > 1.0) return vec4(checker2(uv), 1.0);\n    float z = sqrt(1.0 - 1.0 * d * d); //0.8->radius\n    float r = atan(d, z) / PI; //main deform fuction -> 1.0 / (PI/2) for normalization, then /2 for scale to [0,0.5]\n\n    float phi = atan(uv.y, uv.x);\n    uv = vec2(r * cos(phi), r * sin(phi) * ratio.x);\n    uv *= 1.8;//intensity\n    uv += vec2(0.5);\n    return vec4(checker(uv), 1.0);\n}\n\nvec4 reverse(sampler2D texture) {\n    vec2 tex = textureCoordinate;\n    tex.y = 1. - tex.y;\n    return texture2D(texture, tex);\n}\n\nvec4 blend_normal(vec4 base, vec4 overlay) {\n    return base + overlay * (1.0 - base.a);\n}\n\nvoid main() {\n    vec2 uv = textureCoordinate.xy * 2. - vec2(1.);\n    uv /= 1.4;//radius of visible\n    uv /= vec2(1., ratio.x);\n\n    vec4 fragColor = getColor(uv);\n    vec4 boxColor = texture2D(boxTexture, textureCoordinate);\n    vec4 bottomColor = texture2D(bottomTexture, textureCoordinate);\n\n    fragColor = blend_normal(bottomColor, fragColor);\n    fragColor = blend_normal(boxColor, fragColor);\n    gl_FragColor = fragColor;\n}";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.boxTextureHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)"boxTexture");
        this.bottomTextureHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)"bottomTexture");
        this.ratioHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)"ratio");
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        if (this.boxTexture == 0) {
            this.boxTexture = ImageHelper.bitmapToTexture(ImageHelper.getBitmapByPath(this.imagePaths[0]));
        }
        if (this.bottomTexture == 0) {
            this.bottomTexture = ImageHelper.bitmapToTexture(ImageHelper.getBitmapByPath(this.imagePaths[1]));
        }
        float f = (float)this.getWidth() / (float)this.getHeight();
        GLES20.glUniform2f((int)this.ratioHandler, (float)f, (float)(1.0f / f));
        GLES20.glActiveTexture((int)33985);
        GLES20.glBindTexture((int)3553, (int)this.bottomTexture);
        GLES20.glUniform1i((int)this.bottomTextureHandler, (int)1);
        GLES20.glActiveTexture((int)33986);
        GLES20.glBindTexture((int)3553, (int)this.boxTexture);
        GLES20.glUniform1i((int)this.boxTextureHandler, (int)2);
    }

    @Override
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        this.setWidth(source.getWidth());
        this.setHeight(source.getHeight());
        super.newTextureReady(texture, source, newData);
    }

    @Override
    public void releaseFrameBuffer() {
        super.releaseFrameBuffer();
        this.deleteTextures();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.deleteTextures();
    }

    private void deleteTextures() {
        if (this.bottomTexture > 0 || this.boxTexture > 0) {
            int[] nArray = new int[]{this.bottomTexture, this.boxTexture};
            GLES20.glDeleteTextures((int)2, (int[])nArray, (int)0);
            this.bottomTexture = 0;
            this.boxTexture = 0;
        }
    }
}

