/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public class EyeEffectFilter
extends BasicFilter {
    public static final String UNIFORM_WIDTH = "width";
    public static final String UNIFORM_HEIGHT = "height";
    private int widthHandler;
    private int heightHandler;

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float width;\nuniform float height;\nconst float PI = 3.1415926535;\n\nvoid main(){\n    vec2 uv = textureCoordinate;\n    float aspectRatio = height/width;\n    float aperture = 178.0;\n    float apertureHalf = 0.5 * aperture * (PI / 180.0);\n    float maxFactor = sin(apertureHalf);    vec2 xy = 1.5 * uv * vec2(1.0,aspectRatio) - 0.75*vec2(1.0,aspectRatio);\n    float d = length(xy);\n    if (d < (2.0-maxFactor))\n    {\n      d = length(xy * maxFactor);\n      float z = sqrt(1.0 - d * d);\n      float r = atan(d, z) / PI;\n      float phi = atan(xy.y, xy.x);\n      \n      uv.x = 1.5*r * cos(phi) + 0.5;\n      uv.y = r * sin(phi) + 0.5;\n    gl_FragColor = texture2D(inputImageTexture0, uv); \n    } else {\n    gl_FragColor = vec4(0.0, 0.0, 0.0, 1);    }\n}";
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.widthHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_WIDTH);
        this.heightHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_HEIGHT);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        if (this.getWidth() != 0 && this.getHeight() != 0) {
            GLES20.glUniform1f((int)this.widthHandler, (float)this.getWidth());
            GLES20.glUniform1f((int)this.heightHandler, (float)this.getHeight());
        }
    }
}

