/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import project.android.imageprocessing.filter.TwoPassMultiPixelFilter;

public class ErosionFilter
extends TwoPassMultiPixelFilter {
    private int erosionRadius;

    public ErosionFilter(int erosionRadius) {
        this.erosionRadius = erosionRadius;
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float texelWidthOffset;\nuniform float texelHeightOffset;\nconst int dilationSize = " + (this.erosionRadius * 2 + 1) + ";\n" + "const int dilationRadius = " + this.erosionRadius + ";\n" + "void main(){\n" + "   vec2 step = vec2(" + "texelWidthOffset" + ", " + "texelHeightOffset" + ");\n" + "   float stepIntensity[dilationSize];\n" + "   for(int i = 0; i < dilationSize; i++) {\n" + "     stepIntensity[i] = texture2D(" + "inputImageTexture0" + ", " + "textureCoordinate" + " + step * float(i - dilationRadius)).r;\n" + "   }\n" + "   float minValue = 1.0;\n" + "   for(int i = 0; i < dilationSize; i++) {\n" + "     minValue = min(minValue, stepIntensity[i]);\n" + "   }\n" + "   gl_FragColor = vec4(vec3(minValue), 1.0);\n" + "}\n";
    }
}

