/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import project.android.imageprocessing.filter.TwoPassMultiPixelFilter;

public class DilationRGBFilter
extends TwoPassMultiPixelFilter {
    private int dilationRadius;

    public DilationRGBFilter(int dilationRadius) {
        this.dilationRadius = dilationRadius;
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float texelWidthOffset;\nuniform float texelHeightOffset;\nconst int dilationSize = " + (this.dilationRadius * 2 + 1) + ";\n" + "const int dilationRadius = " + this.dilationRadius + ";\n" + "void main(){\n" + "   vec2 step = vec2(" + "texelWidthOffset" + ", " + "texelHeightOffset" + ");\n" + "   vec4 stepIntensity[dilationSize];\n" + "   for(int i = 0; i < dilationSize; i++) {\n" + "     stepIntensity[i] = texture2D(" + "inputImageTexture0" + ", " + "textureCoordinate" + " + step * float(i - dilationRadius));\n" + "   }\n" + "   vec4 maxValue = vec4(0,0,0,0);\n" + "   for(int i = 0; i < dilationSize; i++) {\n" + "     maxValue = max(maxValue, stepIntensity[i]);\n" + "   }\n" + "   gl_FragColor = maxValue;\n" + "}\n";
    }
}

