/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public class DazzlingRotation
extends BasicFilter {
    private static final String UNIFORM_POSITION = "position";
    private static final String UNIFORM_DIRECTION = "direction";
    private int positionHandle;
    private int directionHandle;
    private float mShift = 0.0f;
    private float mDirection = 0.0f;
    private boolean isVertical = true;

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float position;\nuniform float direction;\nvoid main(){\nvec4 color;\nif (direction == 1.0){\n float y;\n if (textureCoordinate.x < 0.5) {\n    y = mod(textureCoordinate.y -position, 1.0);\n } else {\n    y = mod(textureCoordinate.y +position, 1.0);\n }\n    color = texture2D(inputImageTexture0, vec2(textureCoordinate.x,y));\n} else {\n float x;\n if (textureCoordinate.y < 0.5) {\n    x = mod(textureCoordinate.x -position, 1.0);\n } else {\n    x = mod(textureCoordinate.x +position, 1.0);\n }\n    color = texture2D(inputImageTexture0, vec2(x,textureCoordinate.y));\n}\ngl_FragColor = color;\n}\n";
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.positionHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_POSITION);
        this.directionHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_DIRECTION);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        if (0.5 - (double)this.mShift < 0.02) {
            this.mShift = 0.0f;
            this.isVertical = !this.isVertical;
        }
        this.mShift += 0.02f;
        if (this.isVertical) {
            GLES20.glUniform1f((int)this.directionHandle, (float)1.0f);
        } else {
            GLES20.glUniform1f((int)this.directionHandle, (float)0.0f);
        }
        GLES20.glUniform1f((int)this.positionHandle, (float)this.mShift);
    }
}

