/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.inter.IVideoTrackTime;

public class CurveWaveFilter
extends BasicFilter
implements IVideoTrackTime {
    private static final String UNIFORM_TIME = "iTime";
    private static final String UNIFORM_COUNT = "count";
    private static final String UNIFORM_CUT = "cut";
    private static final String UNIFORM_START = "isStart";
    private int timeHandle;
    private float time = 0.0f;
    private int countHandle;
    private float count = 0.0f;
    private int cutHandle;
    private int startHandle;
    private long mStartTime = 0L;
    private long mEndTime = 0L;
    private long mPlayTime = 0L;
    private int mCount = 0;
    private boolean useInnerTime = true;
    private long duration = 100000L;
    private long mDuration = 10000L;

    public CurveWaveFilter(long mDuration) {
        this.mDuration = mDuration;
    }

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float iTime;\nuniform float count;\nuniform float cut;\nuniform float isStart;\nvoid main(){\nvec2 uv = textureCoordinate;\n if (isStart == 1.0) {if (mod(count,2.0) == 0.0) {\n  uv.x += sin(150.0*uv.y )*cos(100.0*uv.y)*cos(50.0*uv.y)*1.0*0.03;\n} else if (mod(count,3.0) == 0.0){\n  uv.x += sin(150.0*uv.y )*cos(10.0*uv.y)*cos(50.0*uv.y)*1.0*0.02;\n} else {  uv.x += sin(150.0*uv.y )*cos(100.0*uv.y)*cos(40.0*uv.y)*1.0*0.03;\n}\nif (cut == 1.0) {\n if (uv.x >= 0.190 && uv.x < 0.24375) {   uv.x = 0.5 + uv.x + 0.025*2.2;\n }\n uv = uv - vec2(0.025,0.0);\n} else {\nuv.x = mod(uv.x - 0.025, 1.0);\n}\n}vec4 color = texture2D(inputImageTexture0, vec2(uv.x,uv.y));\ngl_FragColor = color;\n}\n";
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.mStartTime = System.currentTimeMillis();
        this.timeHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TIME);
        this.countHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_COUNT);
        this.cutHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_CUT);
        this.startHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_START);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        this.count += 1.0f;
        if (this.useInnerTime) {
            this.time = (float)(System.currentTimeMillis() % this.duration) / 1000.0f;
        }
        GLES20.glUniform1f((int)this.timeHandle, (float)this.time);
        GLES20.glUniform1f((int)this.countHandle, (float)this.count);
        if ((float)this.getWidth() / (float)this.getHeight() != 0.5625f) {
            GLES20.glUniform1f((int)this.cutHandle, (float)1.0f);
        } else {
            GLES20.glUniform1f((int)this.cutHandle, (float)0.0f);
        }
        this.mEndTime = System.currentTimeMillis() - this.mStartTime;
        long l = this.mEndTime / this.mDuration;
        this.mEndTime -= l * this.mDuration;
        if (this.mEndTime >= this.mPlayTime && this.mCount < 3) {
            GLES20.glUniform1f((int)this.startHandle, (float)1.0f);
            ++this.mCount;
        } else if (this.mEndTime >= this.mPlayTime && this.mCount >= 3) {
            GLES20.glUniform1f((int)this.startHandle, (float)0.0f);
        } else {
            GLES20.glUniform1f((int)this.startHandle, (float)0.0f);
            this.mCount = 0;
        }
    }

    @Override
    public void setTimeStamp(long ms) {
        long l = ms % this.duration;
        this.time = (float)l / 1000.0f;
        this.useInnerTime = false;
    }

    public void setPlayTime(long ms) {
        this.mPlayTime = ms;
    }
}

