/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.inter.IVideoTrackTime;

public class CurlPageFilter
extends BasicFilter
implements IVideoTrackTime {
    public static final String UNIFORM_TIME = "iTime";
    private int timeHandler;
    private float time = 0.0f;
    private boolean useInnerTime = true;
    private long duration = 100000L;

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float iTime;\n #define PI 3.141592\nconst float radius = 0.1;\n#define DIST 2\nvec3 cyl = vec3(0.0);\nvec2 curlFun(float t, float maxt){\nvec2 ret = vec2(t, 1.0);    \n    if (t < cyl[DIST] - radius)\n        return ret;\t\t\t\t\nif (t > cyl[DIST] + radius)\n        return vec2(-1.0);\n    float a = asin((t - cyl[DIST]) / radius);\n    float ca = -a + PI;\n    ret.x = cyl[DIST] + ca * radius;\n    ret.y = cos(ca);\n    if (ret.x < maxt)  \n        return ret;\n    if (t < cyl[DIST])\n        return vec2(t, 1.0);\n    ret.y = cos(a);\n    ret.x = cyl[DIST] + a * radius;\n    return ret.x < maxt ? ret : vec2(-1.0);\n}\nvoid main(){\n    vec2 uv = textureCoordinate;\n    vec2 ur = vec2(1.0, 1.0);\n    vec2 mouse = vec2(0.5,0.5)*(sin(iTime*0.6)*0.8+0.9);\n    float d = length(mouse * (1.0 + 4.0*radius)) - 2.0*radius;\n    cyl = vec3(normalize(mouse), d);\n    d = dot(uv, cyl.xy);\n    vec2 end = abs((ur - uv) / cyl.xy);\n    float maxt = d + min(end.x, end.y);\n    vec2 cf = curlFun(d, maxt);\n    vec2 tuv = uv + cyl.xy * (cf.x - d);    \n    float shadow = 1.0 - smoothstep (0.0, radius * 2.0, -(d - cyl[DIST]));\n    shadow *= (smoothstep(-radius, radius, (maxt - (cf.x + 1.5 * PI * radius + radius))));\n    vec4 curr = texture2D(inputImageTexture0, tuv / ur);\n    curr = cf.y > 0.0 ? curr * cf.y  * (1.0 - shadow): (curr * 0.25 + 0.75) * (-cf.y);\n    shadow = smoothstep (0.0, radius * 2.0, (d - cyl[DIST]));\n    vec4 next = texture2D(inputImageTexture0, uv / ur) * shadow;\n    gl_FragColor = cf.x > 0.0 ? curr : next;}\n";
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.timeHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TIME);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        if (this.useInnerTime) {
            this.time = (float)(System.currentTimeMillis() % this.duration) / 1000.0f;
        }
        GLES20.glUniform1f((int)this.timeHandler, (float)this.time);
    }

    @Override
    public void setTimeStamp(long ms) {
        long l = ms % this.duration;
        this.time = (float)l / 1000.0f;
        this.useInnerTime = false;
    }
}

